/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;

public final class VMIndexLinkedList
implements Cloneable,
IndexLinkedList {
    private transient IndexItem root;
    private transient int size = 0;

    public VMIndexLinkedList(IndexItem header) {
        this.root.next = this.root.prev = (this.root = header);
    }

    public IndexItem getRoot() {
        return this.root;
    }

    public IndexItem getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.root.next;
    }

    public IndexItem getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.root.prev;
    }

    public StoreEntry removeFirst() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.next;
        this.remove(this.root.next);
        return result;
    }

    public Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.prev;
        this.remove(this.root.prev);
        return result;
    }

    public void addFirst(IndexItem item) {
        this.addBefore(item, this.root.next);
    }

    public void addLast(IndexItem item) {
        this.addBefore(item, this.root);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(IndexItem item) {
        this.addBefore(item, this.root);
        return true;
    }

    public void clear() {
        this.root.next = this.root.prev = this.root;
        this.size = 0;
    }

    public IndexItem get(int index) {
        return this.entry(index);
    }

    public void add(int index, IndexItem element) {
        this.addBefore(element, index == this.size ? this.root : this.entry(index));
    }

    public Object remove(int index) {
        IndexItem e = this.entry(index);
        this.remove(e);
        return e;
    }

    private IndexItem entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        IndexItem e = this.root;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.prev;
            }
        }
        return e;
    }

    public int indexOf(StoreEntry o) {
        int index = 0;
        IndexItem e = this.root.next;
        while (e != this.root) {
            if (o == e) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    public IndexItem getNextEntry(IndexItem entry) {
        return entry.next != this.root ? entry.next : null;
    }

    public IndexItem getPrevEntry(IndexItem entry) {
        return entry.prev != this.root ? entry.prev : null;
    }

    public void addBefore(IndexItem insert, IndexItem e) {
        insert.next = e;
        insert.prev = e.prev;
        insert.prev.next = insert;
        insert.next.prev = insert;
        ++this.size;
    }

    public void remove(IndexItem e) {
        if (e == this.root) {
            return;
        }
        e.prev.next = e.next;
        e.next.prev = e.prev;
        --this.size;
    }

    public Object clone() {
        VMIndexLinkedList clone = new VMIndexLinkedList(this.root);
        IndexItem e = this.root.next;
        while (e != this.root) {
            clone.add(e);
            e = e.next;
        }
        return clone;
    }

    public StoreEntry getEntry(StoreEntry current) {
        return current;
    }

    public StoreEntry refreshEntry(StoreEntry current) {
        return current;
    }
}

