/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.DestinationMap;

public class VirtualDestinationInterceptor
implements DestinationInterceptor {
    private DestinationMap destinationMap = new DestinationMap();
    private VirtualDestination[] virtualDestinations;

    public Destination intercept(Destination destination) {
        Set virtualDestinations = this.destinationMap.get(destination.getActiveMQDestination());
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        Iterator iter = virtualDestinations.iterator();
        while (iter.hasNext()) {
            VirtualDestination virtualDestination = (VirtualDestination)iter.next();
            Destination newNestination = virtualDestination.intercept(destination);
            destinations.add(newNestination);
        }
        if (!destinations.isEmpty()) {
            if (destinations.size() == 1) {
                return (Destination)destinations.get(0);
            }
            return this.createCompositeDestination(destination, destinations);
        }
        return destination;
    }

    public VirtualDestination[] getVirtualDestinations() {
        return this.virtualDestinations;
    }

    public void setVirtualDestinations(VirtualDestination[] virtualDestinations) {
        this.destinationMap = new DestinationMap();
        this.virtualDestinations = virtualDestinations;
        for (int i = 0; i < virtualDestinations.length; ++i) {
            VirtualDestination virtualDestination = virtualDestinations[i];
            this.destinationMap.put(virtualDestination.getVirtualDestination(), virtualDestination);
        }
    }

    protected Destination createCompositeDestination(Destination destination, final List destinations) {
        return new DestinationFilter(destination){

            public void send(ConnectionContext context, Message messageSend) throws Exception {
                Iterator iter = destinations.iterator();
                while (iter.hasNext()) {
                    Destination destination = (Destination)iter.next();
                    destination.send(context, messageSend);
                }
            }
        };
    }
}

