/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRegion
implements Region {
    private static final Log log = LogFactory.getLog((Class)AbstractRegion.class);
    protected final ConcurrentHashMap destinations = new ConcurrentHashMap();
    protected final DestinationMap destinationMap = new DestinationMap();
    protected final ConcurrentHashMap subscriptions = new ConcurrentHashMap();
    protected final UsageManager memoryManager;
    protected final DestinationFactory destinationFactory;
    protected final DestinationStatistics destinationStatistics;
    protected final RegionBroker broker;
    protected boolean autoCreateDestinations = true;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final Object destinationsMutex = new Object();
    protected final Map consumerChangeMutexMap = new HashMap();

    public AbstractRegion(RegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        if (broker == null) {
            throw new IllegalArgumentException("null broker");
        }
        this.broker = broker;
        this.destinationStatistics = destinationStatistics;
        this.memoryManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        if (broker == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.destinationFactory = destinationFactory;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        log.debug((Object)("Adding destination: " + destination));
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.get((Object)destination);
            if (dest != null) {
                log.warn((Object)("Attempt to add destination which is already created: " + destination));
            } else {
                dest = this.createDestination(context, destination);
                DestinationInterceptor destinationInterceptor = this.broker.getDestinationInterceptor();
                if (destinationInterceptor != null) {
                    dest = destinationInterceptor.intercept(dest);
                }
                dest.start();
                this.destinations.put((Object)destination, (Object)dest);
                this.destinationMap.put(destination, dest);
                Iterator iter = this.subscriptions.values().iterator();
                while (iter.hasNext()) {
                    Subscription sub = (Subscription)iter.next();
                    if (!sub.matches(destination)) continue;
                    dest.addSubscription(context, sub);
                }
            }
            return dest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            Iterator iter = this.subscriptions.values().iterator();
            while (iter.hasNext()) {
                Subscription sub = (Subscription)iter.next();
                if (!sub.matches(destination)) continue;
                throw new JMSException("Destination still has an active subscription: " + destination);
            }
        }
        if (timeout > 0L) {
            // empty if block
        }
        log.debug((Object)("Removing destination: " + destination));
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.remove((Object)destination);
            if (dest != null) {
                Iterator iter = this.subscriptions.values().iterator();
                while (iter.hasNext()) {
                    Subscription sub = (Subscription)iter.next();
                    if (!sub.matches(destination)) continue;
                    dest.removeSubscription(context, sub);
                }
                this.destinationMap.removeAll(destination);
                dest.dispose(context);
                dest.stop();
            } else {
                log.debug((Object)("Destination doesn't exist: " + dest));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDestinations(ActiveMQDestination destination) {
        Object object = this.destinationsMutex;
        synchronized (object) {
            return this.destinationMap.get(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDestinationMap() {
        Object object = this.destinationsMutex;
        synchronized (object) {
            return new HashMap(this.destinations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Object addGuard;
        log.debug((Object)("Adding consumer: " + info.getConsumerId()));
        ActiveMQDestination destination = info.getDestination();
        if (destination != null && !destination.isPattern() && !destination.isComposite()) {
            this.lookup(context, destination);
        }
        Object object = this.consumerChangeMutexMap;
        synchronized (object) {
            addGuard = this.consumerChangeMutexMap.get(info.getConsumerId());
            if (addGuard == null) {
                addGuard = new Object();
                this.consumerChangeMutexMap.put(info.getConsumerId(), addGuard);
            }
        }
        object = addGuard;
        synchronized (object) {
            Object dest;
            Object o = this.subscriptions.get((Object)info.getConsumerId());
            if (o != null) {
                log.warn((Object)"A duplicate subscription was detected. Clients may be misbehaving. Later warnings you may see about subscription removal are a consequence of this.");
                return (Subscription)o;
            }
            Subscription sub = this.createSubscription(context, info);
            Set inactiveDests = this.getInactiveDestinations();
            Iterator iter = inactiveDests.iterator();
            while (iter.hasNext()) {
                dest = (ActiveMQDestination)iter.next();
                if (!sub.matches((ActiveMQDestination)dest)) continue;
                context.getBroker().addDestination(context, (ActiveMQDestination)dest);
            }
            this.subscriptions.put((Object)info.getConsumerId(), (Object)sub);
            iter = this.destinationMap.get(info.getDestination()).iterator();
            while (iter.hasNext()) {
                dest = (Destination)iter.next();
                dest.addSubscription(context, sub);
            }
            if (info.isBrowser()) {
                ((QueueBrowserSubscription)sub).browseDone();
            }
            return sub;
        }
    }

    public Set getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    protected Set getInactiveDestinations() {
        Set inactiveDests = this.destinationFactory.getDestinations();
        inactiveDests.removeAll(this.destinations.keySet());
        return inactiveDests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        log.debug((Object)("Removing consumer: " + info.getConsumerId()));
        Subscription sub = (Subscription)this.subscriptions.remove((Object)info.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + info.getConsumerId());
        }
        Iterator iter = this.destinationMap.get(info.getDestination()).iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.removeSubscription(context, sub);
        }
        this.destroySubscription(sub);
        Map map = this.consumerChangeMutexMap;
        synchronized (map) {
            this.consumerChangeMutexMap.remove(info.getConsumerId());
        }
    }

    protected void destroySubscription(Subscription sub) {
        sub.destroy();
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new JMSException("Invalid operation.");
    }

    public void send(ConnectionContext context, Message messageSend) throws Exception {
        Destination dest = this.lookup(context, messageSend.getDestination());
        dest.send(context, messageSend);
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.get((Object)ack.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + ack.getConsumerId());
        }
        sub.acknowledge(context, ack);
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.get((Object)pull.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + pull.getConsumerId());
        }
        return sub.pullMessage(context, pull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookup(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.get((Object)destination);
            if (dest == null) {
                if (this.autoCreateDestinations) {
                    context.getBroker().addDestination(context, destination);
                    dest = (Destination)this.destinations.get((Object)destination);
                }
                if (dest == null) {
                    throw new JMSException("The destination " + destination + " does not exist.");
                }
            }
            return dest;
        }
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.get((Object)messageDispatchNotification.getConsumerId());
        if (sub != null) {
            sub.processMessageDispatchNotification(messageDispatchNotification);
        }
    }

    public void gc() {
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            sub.gc();
        }
        iter = this.destinations.values().iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.gc();
        }
    }

    protected abstract Subscription createSubscription(ConnectionContext var1, ConsumerInfo var2) throws Exception;

    protected Destination createDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        return this.destinationFactory.createDestination(context, destination, this.destinationStatistics);
    }

    public boolean isAutoCreateDestinations() {
        return this.autoCreateDestinations;
    }

    public void setAutoCreateDestinations(boolean autoCreateDestinations) {
        this.autoCreateDestinations = autoCreateDestinations;
    }
}

