/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.DurableSubscriptionView;
import org.apache.activemq.broker.jmx.InactiveDurableSubscriptionView;
import org.apache.activemq.broker.jmx.ManagedQueueRegion;
import org.apache.activemq.broker.jmx.ManagedTempQueueRegion;
import org.apache.activemq.broker.jmx.ManagedTempTopicRegion;
import org.apache.activemq.broker.jmx.ManagedTopicRegion;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.broker.jmx.SubscriptionView;
import org.apache.activemq.broker.jmx.TopicSubscriptionView;
import org.apache.activemq.broker.jmx.TopicView;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationFactoryImpl;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedRegionBroker
extends RegionBroker {
    private static final Log log = LogFactory.getLog((Class)ManagedRegionBroker.class);
    private final MBeanServer mbeanServer;
    private final ObjectName brokerObjectName;
    private final Map topics = new ConcurrentHashMap();
    private final Map queues = new ConcurrentHashMap();
    private final Map temporaryQueues = new ConcurrentHashMap();
    private final Map temporaryTopics = new ConcurrentHashMap();
    private final Map queueSubscribers = new ConcurrentHashMap();
    private final Map topicSubscribers = new ConcurrentHashMap();
    private final Map durableTopicSubscribers = new ConcurrentHashMap();
    private final Map inactiveDurableTopicSubscribers = new ConcurrentHashMap();
    private final Map temporaryQueueSubscribers = new ConcurrentHashMap();
    private final Map temporaryTopicSubscribers = new ConcurrentHashMap();
    private final Map subscriptionKeys = new ConcurrentHashMap();
    private final Map subscriptionMap = new ConcurrentHashMap();
    private final Set registeredMBeans = new CopyOnWriteArraySet();
    private Broker contextBroker;

    public ManagedRegionBroker(BrokerService brokerService, MBeanServer mbeanServer, ObjectName brokerObjectName, TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor) throws IOException {
        super(brokerService, taskRunnerFactory, memoryManager, destinationFactory, destinationInterceptor);
        this.mbeanServer = mbeanServer;
        this.brokerObjectName = brokerObjectName;
    }

    public void start() throws Exception {
        super.start();
        this.buildExistingSubscriptions();
    }

    protected void doStop(ServiceStopper stopper) {
        super.doStop(stopper);
        Iterator iter = this.registeredMBeans.iterator();
        while (iter.hasNext()) {
            ObjectName name = (ObjectName)iter.next();
            try {
                this.mbeanServer.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                log.warn((Object)("The MBean: " + name + " is no longer registered with JMX"));
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        this.registeredMBeans.clear();
    }

    protected Region createQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new ManagedQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new ManagedTempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new ManagedTempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new ManagedTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    public void register(ActiveMQDestination destName, Destination destination) {
        try {
            DestinationView view;
            ObjectName objectName = this.createObjectName(destName);
            if (destination instanceof Queue) {
                view = new QueueView(this, (Queue)destination);
            } else if (destination instanceof Topic) {
                view = new TopicView(this, (Topic)destination);
            } else {
                view = null;
                log.warn((Object)("JMX View is not supported for custom destination: " + destination));
            }
            if (view != null) {
                this.registerDestination(objectName, destName, view);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to register destination " + destName), (Throwable)e);
        }
    }

    public void unregister(ActiveMQDestination destName) {
        try {
            ObjectName objectName = this.createObjectName(destName);
            this.unregisterDestination(objectName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister " + destName), (Throwable)e);
        }
    }

    public ObjectName registerSubscription(ConnectionContext context, Subscription sub) {
        Hashtable<String, String> map = this.brokerObjectName.getKeyPropertyList();
        String objectNameStr = this.brokerObjectName.getDomain() + ":" + "BrokerName=" + map.get("BrokerName") + ",Type=Subscription,";
        String destinationType = "destinationType=" + sub.getConsumerInfo().getDestination().getDestinationTypeAsString();
        String destinationName = "destinationName=" + JMXSupport.encodeObjectNamePart(sub.getConsumerInfo().getDestination().getPhysicalName());
        String clientId = "clientId=" + JMXSupport.encodeObjectNamePart(context.getClientId());
        String persistentMode = "persistentMode=";
        String consumerId = "";
        SubscriptionKey key = new SubscriptionKey(context.getClientId(), sub.getConsumerInfo().getSubscriptionName());
        if (sub.getConsumerInfo().isDurable()) {
            persistentMode = persistentMode + "Durable, subscriptionID=" + JMXSupport.encodeObjectNamePart(sub.getConsumerInfo().getSubscriptionName());
        } else {
            persistentMode = persistentMode + "Non-Durable";
            if (sub.getConsumerInfo() != null && sub.getConsumerInfo().getConsumerId() != null) {
                consumerId = ",consumerId=" + JMXSupport.encodeObjectNamePart(sub.getConsumerInfo().getConsumerId().toString());
            }
        }
        objectNameStr = objectNameStr + persistentMode + ",";
        objectNameStr = objectNameStr + destinationType + ",";
        objectNameStr = objectNameStr + destinationName + ",";
        objectNameStr = objectNameStr + clientId;
        objectNameStr = objectNameStr + consumerId;
        try {
            ObjectName objectName = new ObjectName(objectNameStr);
            SubscriptionView view = sub.getConsumerInfo().isDurable() ? new DurableSubscriptionView(this, context.getClientId(), sub) : (sub instanceof TopicSubscription ? new TopicSubscriptionView(context.getClientId(), (TopicSubscription)sub) : new SubscriptionView(context.getClientId(), sub));
            this.registerSubscription(objectName, sub.getConsumerInfo(), key, view);
            this.subscriptionMap.put(sub, objectName);
            return objectName;
        }
        catch (Exception e) {
            log.error((Object)("Failed to register subscription " + sub), (Throwable)e);
            return null;
        }
    }

    public void unregisterSubscription(Subscription sub) {
        ObjectName name = (ObjectName)this.subscriptionMap.remove(sub);
        if (name != null) {
            try {
                this.unregisterSubscription(name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to unregister subscription " + sub), (Throwable)e);
            }
        }
    }

    protected void registerDestination(ObjectName key, ActiveMQDestination dest, DestinationView view) throws Exception {
        if (dest.isQueue()) {
            if (dest.isTemporary()) {
                this.temporaryQueues.put(key, view);
            } else {
                this.queues.put(key, view);
            }
        } else if (dest.isTemporary()) {
            this.temporaryTopics.put(key, view);
        } else {
            this.topics.put(key, view);
        }
        try {
            this.mbeanServer.registerMBean(view, key);
            this.registeredMBeans.add(key);
        }
        catch (Throwable e) {
            log.warn((Object)("Failed to register MBean: " + key));
            log.debug((Object)("Failure reason: " + e), e);
        }
    }

    protected void unregisterDestination(ObjectName key) throws Exception {
        this.topics.remove(key);
        this.queues.remove(key);
        this.temporaryQueues.remove(key);
        this.temporaryTopics.remove(key);
        if (this.registeredMBeans.remove(key)) {
            try {
                this.mbeanServer.unregisterMBean(key);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to unregister MBean: " + key));
                log.debug((Object)("Failure reason: " + e), e);
            }
        }
    }

    protected void registerSubscription(ObjectName key, ConsumerInfo info, SubscriptionKey subscriptionKey, SubscriptionView view) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        if (dest.isQueue()) {
            if (dest.isTemporary()) {
                this.temporaryQueueSubscribers.put(key, view);
            } else {
                this.queueSubscribers.put(key, view);
            }
        } else if (dest.isTemporary()) {
            this.temporaryTopicSubscribers.put(key, view);
        } else if (info.isDurable()) {
            this.durableTopicSubscribers.put(key, view);
            try {
                ObjectName inactiveName = (ObjectName)this.subscriptionKeys.get(subscriptionKey);
                if (inactiveName != null) {
                    this.inactiveDurableTopicSubscribers.remove(inactiveName);
                    this.registeredMBeans.remove(inactiveName);
                    this.mbeanServer.unregisterMBean(inactiveName);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Unable to unregister inactive durable subscriber: " + subscriptionKey), e);
            }
        } else {
            this.topicSubscribers.put(key, view);
        }
        try {
            this.mbeanServer.registerMBean(view, key);
            this.registeredMBeans.add(key);
        }
        catch (Throwable e) {
            log.warn((Object)("Failed to register MBean: " + key));
            log.debug((Object)("Failure reason: " + e), e);
        }
    }

    protected void unregisterSubscription(ObjectName key) throws Exception {
        DurableSubscriptionView view;
        this.queueSubscribers.remove(key);
        this.topicSubscribers.remove(key);
        this.inactiveDurableTopicSubscribers.remove(key);
        this.temporaryQueueSubscribers.remove(key);
        this.temporaryTopicSubscribers.remove(key);
        if (this.registeredMBeans.remove(key)) {
            try {
                this.mbeanServer.unregisterMBean(key);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to unregister MBean: " + key));
                log.debug((Object)("Failure reason: " + e), e);
            }
        }
        if ((view = (DurableSubscriptionView)this.durableTopicSubscribers.remove(key)) != null) {
            SubscriptionKey subscriptionKey = new SubscriptionKey(view.getClientId(), view.getSubscriptionName());
            SubscriptionInfo info = new SubscriptionInfo();
            info.setClientId(subscriptionKey.getClientId());
            info.setSubcriptionName(subscriptionKey.getSubscriptionName());
            info.setDestination(new ActiveMQTopic(view.getDestinationName()));
            this.addInactiveSubscription(subscriptionKey, info);
        }
    }

    protected void buildExistingSubscriptions() throws Exception {
        HashMap<SubscriptionKey, SubscriptionInfo> subscriptions = new HashMap<SubscriptionKey, SubscriptionInfo>();
        Set destinations = this.destinationFactory.getDestinations();
        if (destinations != null) {
            Iterator iter = destinations.iterator();
            while (iter.hasNext()) {
                SubscriptionInfo[] infos;
                ActiveMQDestination dest = (ActiveMQDestination)iter.next();
                if (!dest.isTopic() || (infos = this.destinationFactory.getAllDurableSubscriptions((ActiveMQTopic)dest)) == null) continue;
                for (int i = 0; i < infos.length; ++i) {
                    SubscriptionInfo info = infos[i];
                    log.debug((Object)("Restoring durable subscription: " + infos));
                    SubscriptionKey key = new SubscriptionKey(info);
                    subscriptions.put(key, info);
                }
            }
        }
        Iterator i = subscriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            SubscriptionKey key = (SubscriptionKey)entry.getKey();
            SubscriptionInfo info = (SubscriptionInfo)entry.getValue();
            this.addInactiveSubscription(key, info);
        }
    }

    protected void addInactiveSubscription(SubscriptionKey key, SubscriptionInfo info) {
        Hashtable<String, String> map = this.brokerObjectName.getKeyPropertyList();
        try {
            ObjectName objectName = new ObjectName(this.brokerObjectName.getDomain() + ":" + "BrokerName=" + map.get("BrokerName") + "," + "Type=Subscription," + "active=false," + "name=" + JMXSupport.encodeObjectNamePart(key.toString()) + "");
            InactiveDurableSubscriptionView view = new InactiveDurableSubscriptionView(this, key.getClientId(), info);
            try {
                this.mbeanServer.registerMBean(view, objectName);
                this.registeredMBeans.add(objectName);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to register MBean: " + key));
                log.debug((Object)("Failure reason: " + e), e);
            }
            this.inactiveDurableTopicSubscribers.put(objectName, view);
            this.subscriptionKeys.put(key, objectName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to register subscription " + info), (Throwable)e);
        }
    }

    public CompositeData[] browse(SubscriptionView view) throws OpenDataException {
        List messages = this.getSubscriberMessages(view);
        CompositeData[] c = new CompositeData[messages.size()];
        for (int i = 0; i < c.length; ++i) {
            try {
                c[i] = OpenTypeSupport.convert((Message)messages.get(i));
                continue;
            }
            catch (Throwable e) {
                log.error((Object)("failed to browse : " + view), e);
            }
        }
        return c;
    }

    public TabularData browseAsTable(SubscriptionView view) throws OpenDataException {
        OpenTypeSupport.OpenTypeFactory factory = OpenTypeSupport.getFactory(ActiveMQMessage.class);
        List messages = this.getSubscriberMessages(view);
        CompositeType ct = factory.getCompositeType();
        TabularType tt = new TabularType("MessageList", "MessageList", ct, new String[]{"JMSMessageID"});
        TabularDataSupport rc = new TabularDataSupport(tt);
        for (int i = 0; i < messages.size(); ++i) {
            rc.put(new CompositeDataSupport(ct, factory.getFields(messages.get(i))));
        }
        return rc;
    }

    protected List getSubscriberMessages(SubscriptionView view) {
        if (!(this.destinationFactory instanceof DestinationFactoryImpl)) {
            throw new RuntimeException("unsupported by " + this.destinationFactory);
        }
        PersistenceAdapter adapter = ((DestinationFactoryImpl)this.destinationFactory).getPersistenceAdapter();
        final ArrayList result = new ArrayList();
        try {
            ActiveMQTopic topic = new ActiveMQTopic(view.getDestinationName());
            TopicMessageStore store = adapter.createTopicMessageStore(topic);
            store.recover(new MessageRecoveryListener(){

                public void recoverMessage(Message message) throws Exception {
                    result.add(message);
                }

                public void recoverMessageReference(String messageReference) throws Exception {
                }

                public void finished() {
                }
            });
        }
        catch (Throwable e) {
            log.error((Object)("Failed to browse messages for Subscription " + view), e);
        }
        return result;
    }

    protected ObjectName[] getTopics() {
        Set set = this.topics.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getQueues() {
        Set set = this.queues.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getTemporaryTopics() {
        Set set = this.temporaryTopics.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getTemporaryQueues() {
        Set set = this.temporaryQueues.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getTopicSubscribers() {
        Set set = this.topicSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getDurableTopicSubscribers() {
        Set set = this.durableTopicSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getQueueSubscribers() {
        Set set = this.queueSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getTemporaryTopicSubscribers() {
        Set set = this.temporaryTopicSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getTemporaryQueueSubscribers() {
        Set set = this.temporaryQueueSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    protected ObjectName[] getInactiveDurableTopicSubscribers() {
        Set set = this.inactiveDurableTopicSubscribers.keySet();
        return set.toArray(new ObjectName[set.size()]);
    }

    public Broker getContextBroker() {
        return this.contextBroker;
    }

    public void setContextBroker(Broker contextBroker) {
        this.contextBroker = contextBroker;
    }

    protected ObjectName createObjectName(ActiveMQDestination destName) throws MalformedObjectNameException {
        Hashtable<String, String> map = this.brokerObjectName.getKeyPropertyList();
        ObjectName objectName = new ObjectName(this.brokerObjectName.getDomain() + ":" + "BrokerName=" + map.get("BrokerName") + "," + "Type=" + JMXSupport.encodeObjectNamePart(destName.getDestinationTypeAsString()) + "," + "Destination=" + JMXSupport.encodeObjectNamePart(destName.getPhysicalName()));
        return objectName;
    }
}

