/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx;
        Object retval = null;
        Method meth = m.getMethod();
        if (this.txManager != null && (tx = this.txManager.getTransaction()) != null) {
            GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
            if (gtx == null) {
                throw new Exception("failed to get global transaction");
            }
            if (meth.equals(TreeCache.optimisticPrepareMethod)) {
                retval = this.validateNodes(gtx);
            } else if (meth.equals(TreeCache.commitMethod)) {
                this.commit(gtx);
            } else if (meth.equals(TreeCache.rollbackMethod)) {
                this.rollBack(gtx);
            } else {
                retval = super.invoke(m);
            }
        } else {
            throw new CacheException("Not in a transaction");
        }
        return retval;
    }

    private Object validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            throw new CacheException("unable to retrieve workspace", (Throwable)((Object)e));
        }
        Collection nodes = workspace.getNodes().values();
        boolean validated = false;
        this.log.debug((Object)"validating nodes");
        validated = this.simpleValidate(nodes);
        if (!validated) {
            throw new CacheException("unable to validate nodes");
        }
        this.log.debug((Object)"validated nodes");
        return null;
    }

    private boolean simpleValidate(Collection nodes) {
        WorkspaceNode wrappedNode = null;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            wrappedNode = (WorkspaceNode)it.next();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("validating version for node " + wrappedNode.getNode().getName()));
            }
            try {
                OptimisticTreeNode realNode = (OptimisticTreeNode)this.cache._get(wrappedNode.getFqn());
                this.log.debug((Object)("real node is " + realNode));
                this.log.debug((Object)("wrapped node is " + wrappedNode));
                if (realNode == null && !wrappedNode.isCreated()) {
                    this.log.warn((Object)("Real node for " + wrappedNode.getFqn() + " is null, and this hasnt been newly created in this tx!"));
                    return false;
                }
                if (wrappedNode.isCreated() || realNode.getVersion() < wrappedNode.getVersion()) continue;
                this.log.info((Object)("DataNode [" + wrappedNode.getNode().getFqn() + "] version number (" + ((OptimisticTreeNode)wrappedNode.getNode()).getVersion() + ") is greater than or equal to workspace node version " + wrappedNode.getVersion()));
                return false;
            }
            catch (CacheException e) {
                this.log.info((Object)"Caught exception dealing with a validate - failing validate.", (Throwable)((Object)e));
                return false;
            }
        }
        return true;
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace = null;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            // empty catch block
        }
        this.log.debug((Object)"commiting validated changes ");
        Collection nodes = workspace.getNodes().values();
        WorkspaceNode wrappedNode = null;
        OptimisticTreeNode current = null;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            wrappedNode = (WorkspaceNode)it.next();
            if (wrappedNode.isDeleted()) {
                DataNode dNode;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Workspace node " + wrappedNode.getFqn() + " is deleted; removing from tree cache"));
                }
                if ((dNode = wrappedNode.getNode()).getFqn().isRoot()) {
                    this.log.warn((Object)"Attempting to delete the root node - this cannot be done!");
                    continue;
                }
                DataNode parent = (DataNode)dNode.getParent();
                parent.removeChild(dNode.getName());
                continue;
            }
            if (wrappedNode.isDirty()) {
                current = (OptimisticTreeNode)wrappedNode.getNode();
                Map mergedChildren = wrappedNode.getMergedChildren();
                if (current.getChildren() == null) {
                    current.setChildren(mergedChildren);
                } else {
                    current.getChildren().clear();
                    current.getChildren().putAll(mergedChildren);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("inserting merged data " + wrappedNode.getMergedData()));
                }
                Map mergedData = wrappedNode.getMergedData();
                current.put(mergedData, true);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Setting version of data node " + current.getName() + " from " + current.getVersion() + " to " + wrappedNode.getVersion()));
                }
                current.setVersion(wrappedNode.getVersion());
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("committed changes for  " + current.getName()));
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Merging node " + wrappedNode.getFqn() + " not necessary since the node is not dirty"));
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        block2: {
            workspace = null;
            try {
                workspace = this.getTransactionWorkspace(gtx);
            }
            catch (CacheException e) {
                if (!this.log.isInfoEnabled()) break block2;
                this.log.info((Object)"Unable to roll back: ", (Throwable)((Object)e));
            }
        }
        Map nodes = workspace.getNodes();
        nodes.clear();
    }
}

