/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.TreeCache;
import org.jgroups.blocks.MethodCall;

public abstract class Interceptor {
    Interceptor next = null;
    TreeCache cache = null;
    Log log = LogFactory.getLog(this.getClass());

    public void setNext(Interceptor i) {
        this.next = i;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public Object invoke(MethodCall m) throws Throwable {
        return this.next.invoke(m);
    }

    boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    boolean isValid(Transaction tx) {
        return this.isActive(tx) || this.isPreparing(tx);
    }
}

