/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.WriteReplaceable;

public class WriteReplacer
implements WriteReplaceable {
    Object obj;

    public WriteReplacer(Object obj) {
        this.obj = obj;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this.obj instanceof Advised) {
            InstanceAdvisor advisor = ((Advised)this.obj)._getInstanceAdvisor();
            Interceptor[] interceptors = advisor.getInterceptors();
            CacheInterceptor cacheInterceptor = null;
            int i = 0;
            while (i < interceptors.length) {
                if (interceptors[i] instanceof CacheInterceptor) {
                    cacheInterceptor = (CacheInterceptor)interceptors[i];
                    break;
                }
                ++i;
            }
            if (cacheInterceptor != null) {
                try {
                    cacheInterceptor.beforeSerialization(this.obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new NotSerializableException(e.getMessage());
                }
            }
        }
        return this.obj;
    }
}

