/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class ObjRecord
extends WritableRecordData {
    private ObjType type;
    private boolean read;
    private int objectId;
    public static final ObjType PICTURE = new ObjType(8);
    public static final ObjType CHART = new ObjType(5);
    private static final int COMMON_DATA_LENGTH = 22;
    private static final int CLIPBOARD_FORMAT_LENGTH = 6;
    private static final int PICTURE_OPTION_LENGTH = 6;
    private static final int END_LENGTH = 4;

    public ObjRecord(Record t) {
        super(t);
        byte[] data = t.getData();
        int objtype = IntegerHelper.getInt(data[4], data[5]);
        this.read = true;
        if (objtype == ObjRecord.CHART.value) {
            this.type = CHART;
        } else if (objtype == ObjRecord.PICTURE.value) {
            this.type = PICTURE;
        }
        this.objectId = IntegerHelper.getInt(data[6], data[7]);
    }

    ObjRecord(int objId) {
        super(Type.OBJ);
        this.objectId = objId;
        this.type = PICTURE;
    }

    public byte[] getData() {
        if (this.read) {
            return this.getRecord().getData();
        }
        int dataLength = 38;
        int pos = 0;
        byte[] data = new byte[dataLength];
        IntegerHelper.getTwoBytes(21, data, pos);
        IntegerHelper.getTwoBytes(18, data, pos + 2);
        IntegerHelper.getTwoBytes(this.type.value, data, pos + 4);
        IntegerHelper.getTwoBytes(this.objectId, data, pos + 6);
        IntegerHelper.getTwoBytes(24593, data, pos + 8);
        IntegerHelper.getTwoBytes(7, data, pos += 22);
        IntegerHelper.getTwoBytes(2, data, pos + 2);
        IntegerHelper.getTwoBytes(65535, data, pos + 4);
        IntegerHelper.getTwoBytes(8, data, pos += 6);
        IntegerHelper.getTwoBytes(2, data, pos + 2);
        IntegerHelper.getTwoBytes(1, data, pos + 4);
        IntegerHelper.getTwoBytes(0, data, pos += 6);
        IntegerHelper.getTwoBytes(0, data, pos + 2);
        pos += 4;
        return data;
    }

    public Record getRecord() {
        return super.getRecord();
    }

    public ObjType getType() {
        return this.type;
    }

    private static final class ObjType {
        int value;

        ObjType(int v) {
            this.value = v;
        }
    }
}

