/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry.local;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.registry.local.Registry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestHandler
implements Runnable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$registry$local$RequestHandler == null ? (class$org$apache$juddi$registry$local$RequestHandler = RequestHandler.class$("org.apache.juddi.registry.local.RequestHandler")) : class$org$apache$juddi$registry$local$RequestHandler));
    private static DocumentBuilder docBuilder = null;
    private volatile String version;
    private volatile String operation;
    private volatile Element uddiReq;
    private volatile Node response;
    private volatile String exception;
    static /* synthetic */ Class class$org$apache$juddi$registry$local$RequestHandler;

    public String getOperation(Element uddiReq) throws Exception {
        if (uddiReq == null) {
            throw new FatalErrorException("A UDDI request was not found in the SOAP message.");
        }
        String operation = uddiReq.getLocalName();
        if (operation == null || operation.trim().length() == 0) {
            throw new FatalErrorException("The UDDI service operation could not be identified.");
        }
        this.setOperation(operation);
        return operation;
    }

    public String getVersion(Element uddiReq, String operation) throws Exception {
        String version = uddiReq.getAttribute("generic");
        if (version == null) {
            throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + operation + " (The " + "'generic' attribute must be present)");
        }
        this.setVersion(version);
        return version;
    }

    public void run() {
        try {
            HandlerMaker maker = HandlerMaker.getInstance();
            AbstractHandler requestHandler = maker.lookup(this.operation);
            if (requestHandler == null) {
                throw new UnsupportedException("The UDDI service operation specified is unknown or unsupported: " + this.operation);
            }
            RegistryObject uddiReqObj = requestHandler.unmarshal(this.uddiReq);
            RegistryObject uddiResObj = null;
            RegistryEngine registry = Registry.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is currently unavailable.");
            }
            uddiResObj = registry.execute(uddiReqObj);
            AbstractHandler responseHandler = maker.lookup(uddiResObj.getClass().getName());
            if (responseHandler == null) {
                throw new FatalErrorException("The response object type is unknown: " + uddiResObj.getClass().getName());
            }
            DocumentBuilder docBuilder = this.getDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element element = document.createElement("temp");
            responseHandler.marshal(uddiResObj, element);
            document.appendChild(element.getFirstChild());
            this.setResponse(document);
        }
        catch (Exception ex) {
            String faultCode = null;
            String faultString = null;
            String faultActor = null;
            String errno = null;
            String errCode = null;
            String errText = null;
            if (ex instanceof RegistryException) {
                log.error((Object)ex.getMessage());
                RegistryException rex = (RegistryException)ex;
                faultCode = rex.getFaultCode();
                faultString = rex.getFaultString();
                faultActor = rex.getFaultActor();
                DispositionReport dispRpt = rex.getDispositionReport();
                if (dispRpt != null) {
                    Result result = null;
                    ErrInfo errInfo = null;
                    Vector results = dispRpt.getResultVector();
                    if (results != null && !results.isEmpty()) {
                        result = (Result)results.elementAt(0);
                    }
                    if (result != null) {
                        errno = String.valueOf(result.getErrno());
                        errInfo = result.getErrInfo();
                        if (errInfo != null) {
                            errCode = errInfo.getErrCode();
                            errText = errInfo.getErrMsg();
                        }
                    }
                }
            } else if (ex instanceof SOAPException) {
                log.error((Object)ex.getMessage());
                faultCode = "Client";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode(10500);
                errText = Result.lookupErrText(10500) + " " + ex.getMessage();
            } else {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                faultCode = "Server";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode(10500);
                errText = Result.lookupErrText(10500) + " An internal UDDI server error has " + "occurred. Please report this error " + "to the UDDI server administrator.";
            }
            String fault = "faultCode=" + faultCode + ", faultString=" + faultString + ", faultActor=" + faultActor + ", errno=" + errno + ", errCode=" + errCode + ", errText=" + errText;
            this.setException(fault);
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Node getResponse() {
        return this.response;
    }

    public void setResponse(Node response) {
        this.response = response;
    }

    public Element getUddiReq() {
        return this.uddiReq;
    }

    public void setUddiReq(Element uddiReq) {
        this.uddiReq = uddiReq;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

