/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BusinessInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "businessInfo";
    private HandlerMaker maker = null;

    protected BusinessInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        BusinessInfo obj = new BusinessInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setBusinessKey(element.getAttribute("businessKey"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("name");
            Name name = (Name)handler.unmarshal((Element)nodeList.elementAt(i));
            if (name == null) continue;
            obj.addName(name);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            Description descr = (Description)handler.unmarshal((Element)nodeList.elementAt(i));
            if (descr == null) continue;
            obj.addDescription(descr);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "serviceInfos");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("serviceInfos");
            obj.setServiceInfos((ServiceInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        ServiceInfos infos;
        Vector descVector;
        Vector nameVector;
        BusinessInfo info = (BusinessInfo)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        String businessKey = info.getBusinessKey();
        if (businessKey != null) {
            element.setAttribute("businessKey", businessKey);
        }
        if ((nameVector = info.getNameVector()) != null && nameVector.size() > 0) {
            handler = this.maker.lookup("name");
            for (int i = 0; i < nameVector.size(); ++i) {
                handler.marshal((Name)nameVector.elementAt(i), element);
            }
        }
        if ((descVector = info.getDescriptionVector()) != null && descVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descVector.size(); ++i) {
                handler.marshal((Description)descVector.elementAt(i), element);
            }
        }
        if ((infos = info.getServiceInfos()) != null) {
            handler = this.maker.lookup("serviceInfos");
            handler.marshal(infos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

