/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AccessPointHandler
extends AbstractHandler {
    public static final String TAG_NAME = "accessPoint";

    protected AccessPointHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        AccessPoint obj = new AccessPoint();
        obj.setURLType(element.getAttribute("URLType"));
        obj.setURL(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String urlValue;
        AccessPoint accessPoint = (AccessPoint)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String urlType = accessPoint.getURLType();
        if (urlType != null) {
            element.setAttribute("URLType", urlType);
        }
        if ((urlValue = accessPoint.getURL()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(urlValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AccessPointHandler handler = new AccessPointHandler(maker);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AccessPoint object = new AccessPoint();
        object.setURLType("http");
        object.setURL("http://www.sviens.com/service.cgi");
        System.out.println();
        RegistryObject regObject = object;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

