/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetSubscriptions;
import org.apache.juddi.datatype.response.Subscriptions;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.InvalidTimeException;
import org.apache.juddi.error.InvalidValueException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetSubscriptionsFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$GetSubscriptionsFunction == null ? (class$org$apache$juddi$function$GetSubscriptionsFunction = GetSubscriptionsFunction.class$("org.apache.juddi.function.GetSubscriptionsFunction")) : class$org$apache$juddi$function$GetSubscriptionsFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$GetSubscriptionsFunction;

    public GetSubscriptionsFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetSubscriptions request = (GetSubscriptions)regObject;
        String generic = request.getGeneric();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            dataStore.commit();
            Subscriptions subs = new Subscriptions();
            subs.setGeneric(generic);
            subs.setOperator(Config.getOperator());
            Subscriptions subscriptions = subs;
            return subscriptions;
        }
        catch (InvalidKeyPassedException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ex);
            throw ex;
        }
        catch (InvalidValueException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ex);
            throw ex;
        }
        catch (UnsupportedException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ex);
            throw ex;
        }
        catch (UserMismatchException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ex);
            throw ex;
        }
        catch (InvalidTimeException ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ex);
            throw ex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

