/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindTModelByNameQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindTModelByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindTModelByNameQuery = FindTModelByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindTModelByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindTModelByNameQuery));
    static String selectSQL;
    static String tablePrefix;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindTModelByNameQuery;

    FindTModelByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String name, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindTModelByNameQuery.appendWhere(sql, name, qualifiers);
        FindTModelByNameQuery.appendIn(sql, name, keysIn);
        FindTModelByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find TModel ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find TModel Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, String name, FindQualifiers qualifiers) {
        if (name == null || name.length() == 0) {
            return;
        }
        sql.append("WHERE M.DELETED IS NULL ");
        if (qualifiers != null && qualifiers.exactNameMatch) {
            sql.append("AND M.NAME = ? ");
            sql.addValue(name);
        } else {
            sql.append("AND M.NAME LIKE ? ");
            sql.addValue(name.endsWith("%") ? name : name + "%");
        }
    }

    private static void appendIn(DynamicQuery sql, String name, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        if (name == null || name.length() == 0) {
            sql.append("WHERE M.TMODEL_KEY IN (");
        } else {
            sql.append("AND M.TMODEL_KEY IN (");
        }
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc && !qualifiers.sortByDateAsc && !qualifiers.sortByDateDesc) {
            sql.append("M.NAME ASC,M.LAST_UPDATE DESC");
        } else if (qualifiers.sortByNameAsc || qualifiers.sortByNameDesc) {
            if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
                if (qualifiers.sortByNameAsc && qualifiers.sortByDateDesc) {
                    sql.append("M.NAME ASC,M.LAST_UPDATE DESC");
                } else if (qualifiers.sortByNameAsc && qualifiers.sortByDateAsc) {
                    sql.append("M.NAME ASC,M.LAST_UPDATE ASC");
                } else if (qualifiers.sortByNameDesc && qualifiers.sortByDateDesc) {
                    sql.append("M.NAME DESC,M.LAST_UPDATE DESC");
                } else {
                    sql.append("M.NAME DESC,M.LAST_UPDATE ASC");
                }
            } else if (qualifiers.sortByNameAsc) {
                sql.append("M.NAME ASC,M.LAST_UPDATE DESC");
            } else {
                sql.append("M.NAME DESC,M.LAST_UPDATE DESC");
            }
        } else if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
            if (qualifiers.sortByDateDesc) {
                sql.append("M.LAST_UPDATE DESC,M.NAME ASC");
            } else {
                sql.append("M.LAST_UPDATE ASC,M.NAME ASC");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = "";
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT M.TMODEL_KEY,M.LAST_UPDATE,M.NAME,M.DELETED ");
        sql.append("FROM ").append(tablePrefix).append("TMODEL M ");
        selectSQL = sql.toString();
    }
}

