/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.util.Config;

class BindingTemplateTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$BindingTemplateTable == null ? (class$org$apache$juddi$datastore$jdbc$BindingTemplateTable = BindingTemplateTable.class$("org.apache.juddi.datastore.jdbc.BindingTemplateTable")) : class$org$apache$juddi$datastore$jdbc$BindingTemplateTable));
    static String insertSQL = null;
    static String deleteSQL = null;
    static String selectSQL = null;
    static String selectByServiceKeySQL = null;
    static String deleteByServiceKeySQL = null;
    static String verifyOwnershipSQL = null;
    static String tablePrefix = "";
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$BindingTemplateTable;

    BindingTemplateTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(BindingTemplate binding, Connection connection) throws SQLException {
        Statement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        try {
            String urlType = null;
            String url = null;
            AccessPoint accessPoint = binding.getAccessPoint();
            if (accessPoint != null) {
                urlType = accessPoint.getURLType();
                url = accessPoint.getURL();
            }
            String redirectorKey = null;
            HostingRedirector redirector = binding.getHostingRedirector();
            if (redirector != null && redirector.getBindingKey() != null) {
                redirectorKey = redirector.getBindingKey();
            }
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, binding.getServiceKey().toString());
            statement.setString(2, binding.getBindingKey().toString());
            statement.setString(3, urlType);
            statement.setString(4, url);
            statement.setString(5, redirectorKey);
            statement.setTimestamp(6, timeStamp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("insert into " + tablePrefix + "BINDING_TEMPLATE table:\n\n\t" + insertSQL + "\n\t SERVICE_KEY=" + binding.getServiceKey().toString() + "\n\t BINDING_KEY=" + binding.getBindingKey().toString() + "\n\t ACCESS_POINT_TYPE=" + urlType + "\n\t ACCESS_POINT_URL=" + url + "\n\t HOSTING_REDIRECTOR=" + redirectorKey + "\n\t LAST_UPDATE=" + timeStamp.getTime() + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("delete from " + tablePrefix + "BINDING_TEMPLATE table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey + "\n"));
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingTemplate select(String bindingKey, Connection connection) throws SQLException {
        BindingTemplate binding = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("select from " + tablePrefix + "BINDING_TEMPLATE table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            }
            if ((resultSet = statement.executeQuery()).next()) {
                String redirectorKey;
                binding = new BindingTemplate();
                binding.setServiceKey(resultSet.getString(1));
                binding.setBindingKey(bindingKey);
                String urlType = resultSet.getString(2);
                String url = resultSet.getString(3);
                if (urlType != null && url != null) {
                    binding.setAccessPoint(new AccessPoint(urlType, url));
                }
                if ((redirectorKey = resultSet.getString(4)) != null) {
                    binding.setHostingRedirector(new HostingRedirector(redirectorKey));
                }
            }
            BindingTemplate bindingTemplate = binding;
            return bindingTemplate;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectByServiceKey(String serviceKey, Connection connection) throws SQLException {
        Vector<BindingTemplate> bindList = new Vector<BindingTemplate>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectByServiceKeySQL);
            statement.setString(1, serviceKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("select from " + tablePrefix + "BINDING_TEMPLATE table:\n\n\t" + selectByServiceKeySQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            }
            resultSet = statement.executeQuery();
            BindingTemplate binding = null;
            while (resultSet.next()) {
                String redirectorKey;
                binding = new BindingTemplate();
                binding.setServiceKey(serviceKey);
                binding.setBindingKey(resultSet.getString(1));
                String urlType = resultSet.getString(2);
                String url = resultSet.getString(3);
                if (urlType != null && url != null) {
                    binding.setAccessPoint(new AccessPoint(urlType, url));
                }
                if ((redirectorKey = resultSet.getString(4)) != null) {
                    binding.setHostingRedirector(new HostingRedirector(redirectorKey));
                }
                bindList.add(binding);
                binding = null;
            }
            Vector<BindingTemplate> vector = bindList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByServiceKey(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteByServiceKeySQL);
            statement.setString(1, serviceKey.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("delete from " + tablePrefix + "BINDING_TEMPLATE table:\n\n\t" + deleteByServiceKeySQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            }
            int returnCode = statement.executeUpdate();
            log.info((Object)("delete was successful, rows deleted=" + returnCode));
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyOwnership(String bindingKey, String publisherID, Connection connection) throws SQLException {
        if (bindingKey == null || publisherID == null) {
            return false;
        }
        boolean authorized = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(verifyOwnershipSQL);
            statement.setString(1, bindingKey);
            statement.setString(2, publisherID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking ownership of BINDING_TEMPLATE:\n\n\t" + verifyOwnershipSQL + "\n\t BINDNG_KEY=" + bindingKey + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            }
            if ((resultSet = statement.executeQuery()).next()) {
                authorized = true;
            }
            boolean bl = authorized;
            return bl;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("BINDING_TEMPLATE (");
        sql.append("SERVICE_KEY,");
        sql.append("BINDING_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR,");
        sql.append("LAST_UPDATE) ");
        sql.append("VALUES (?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ").append(tablePrefix).append("BINDING_TEMPLATE ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("SERVICE_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR ");
        sql.append("FROM ").append(tablePrefix).append("BINDING_TEMPLATE ");
        sql.append("WHERE BINDING_KEY=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("BINDING_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR ");
        sql.append("FROM ").append(tablePrefix).append("BINDING_TEMPLATE ");
        sql.append("WHERE SERVICE_KEY=?");
        selectByServiceKeySQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BINDING_TEMPLATE ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteByServiceKeySQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("* ");
        sql.append("FROM ").append(tablePrefix).append("BUSINESS_ENTITY e, ").append(tablePrefix).append("BUSINESS_SERVICE s, ").append(tablePrefix).append("BINDING_TEMPLATE t ");
        sql.append("WHERE s.SERVICE_KEY = t.SERVICE_KEY ");
        sql.append("AND e.BUSINESS_KEY = s.BUSINESS_KEY ");
        sql.append("AND t.BINDING_KEY=? ");
        sql.append("AND e.PUBLISHER_ID=?");
        verifyOwnershipSQL = sql.toString();
    }
}

