/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.A;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.CertificateDecodeException;
import com.enterprisedt.net.puretls.cert.CertificateException;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.D;
import com.enterprisedt.net.puretls.cert.X509Ext;
import com.enterprisedt.net.puretls.cert.X509Name;
import com.enterprisedt.net.puretls.cert.X509SubjectPublicKeyInfo;
import com.enterprisedt.net.puretls.sslg.CertVerifyPolicyInt;
import com.enterprisedt.net.puretls.sslg.Certificate;
import com.enterprisedt.net.puretls.sslg.DistinguishedName;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class X509Cert
implements Certificate {
    private static Logger I = Logger.getLogger(class$com$enterprisedt$net$puretls$cert$X509Cert == null ? (class$com$enterprisedt$net$puretls$cert$X509Cert = X509Cert.class$("com.enterprisedt.net.puretls.cert.X509Cert")) : class$com$enterprisedt$net$puretls$cert$X509Cert);
    ASNObject B;
    ASNObject E;
    ASNObject N;
    ASNObject G;
    ASNObject O;
    ASNObject D;
    byte[] J;
    byte[] R;
    byte[] U;
    byte[] A;
    byte[] M;
    String K;
    PublicKey P;
    X509Name Q;
    X509Name L;
    BigInteger F;
    Date H;
    Date T;
    Vector S = null;
    private static Hashtable C = new Hashtable();
    static /* synthetic */ Class class$com$enterprisedt$net$puretls$cert$X509Cert;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Cert(byte[] byArray) throws CertificateException {
        this.J = byArray;
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            ASNObject aSNObject = CertContext.getSpec().getComponent("UsefulCertificate");
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            try {
                aSNObject.accept(coderOperations, null);
                this.B = aSNObject;
                ASNObject aSNObject2 = aSNObject.getComponent("UsefulCertificate.tbsCertificate");
                this.R = (byte[])aSNObject2.getValue();
                this.O = aSNObject.getComponent("UsefulCertificate.signatureAlgorithm");
                Vector vector = (Vector)this.O.getValue();
                Vector vector2 = (Vector)vector.elementAt(0);
                this.K = (String)vector2.elementAt(0);
                SSLDebug.debug(32, "Signed by " + this.K);
                this.D = aSNObject.getComponent("UsefulCertificate.signature");
                byte[] byArray2 = (byte[])this.D.getValue();
                if (byArray2[0] != 0) {
                    throw new IOException();
                }
                this.M = new byte[byArray2.length - 1];
                System.arraycopy(byArray2, 1, this.M, 0, this.M.length);
                SSLDebug.debug(32, "Signature ", this.M);
                this.E = CertContext.getSpec().getComponent("UsefulTBSCertificate");
                ASNObject aSNObject3 = this.E.getComponent("UsefulTBSCertificate.extensions");
                aSNObject3.setValue(aSNObject3.getDefaultValue());
                ASNObject aSNObject4 = this.E.getComponent("UsefulTBSCertificate.version");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                aSNObject4 = this.E.getComponent("UsefulTBSCertificate.issuerUniqueID");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                aSNObject4 = this.E.getComponent("UsefulTBSCertificate.subjectUniqueID");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                SSLDebug.debug(32, "Unsigned cert DER", this.R);
                byteArrayInputStream = new ByteArrayInputStream(this.R);
                coderOperations.init(byteArrayInputStream);
                this.E.accept(coderOperations, null);
                this.N = this.E.getComponent("UsefulTBSCertificate.issuer");
                this.A = (byte[])this.N.getValue();
                SSLDebug.debug(32, "Issuer DER", this.A);
                this.L = new X509Name(this.A);
                SSLDebug.debug(32, "Issuer Name = ", this.L.getNameString());
                this.G = this.E.getComponent("UsefulTBSCertificate.subject");
                this.U = (byte[])this.G.getValue();
                SSLDebug.debug(32, "Subject DER", this.U);
                this.Q = new X509Name(this.U);
                SSLDebug.debug(32, "Subject Name = ", this.Q.getNameString());
                ASNObject aSNObject5 = this.E.getComponent("UsefulTBSCertificate.subjectPublicKeyInfo");
                byte[] byArray3 = (byte[])aSNObject5.getValue();
                this.P = X509SubjectPublicKeyInfo.createPublicKey(byArray3);
                aSNObject2 = this.E.getComponent("UsefulTBSCertificate.serialNumber");
                this.F = (BigInteger)aSNObject2.getValue();
                SSLDebug.debug(32, "Serial Number = ", this.F.toString());
                ASNObject aSNObject6 = this.E.getComponent("UsefulTBSCertificate.validity");
                aSNObject2 = aSNObject6.getComponent("Validity.notBefore");
                this.H = (Date)aSNObject2.getValue();
                SSLDebug.debug(32, "Not valid before ", this.H);
                aSNObject2 = aSNObject6.getComponent("Validity.notAfter");
                SSLDebug.debug(32, "Not valid after ", this.T);
                this.T = (Date)aSNObject2.getValue();
                ASNObject aSNObject7 = this.E.getComponent("UsefulTBSCertificate.extensions");
                vector = (Vector)aSNObject7.getValue();
                if (vector != null) {
                    SSLDebug.debug(32, "Number of extensions = ", vector.size());
                    for (int i2 = 0; i2 < vector.size(); ++i2) {
                        if (i2 == 0) {
                            this.S = new Vector();
                        }
                        vector2 = (Vector)vector.elementAt(i2);
                        byte[] byArray4 = (byte[])vector2.elementAt(0);
                        SSLDebug.debug(32, "Extension " + i2, byArray4);
                        this.S.addElement(new X509Ext(byArray4));
                    }
                } else {
                    SSLDebug.debug(32, "No extensions");
                }
            }
            catch (IOException iOException) {
                throw new CertificateDecodeException(iOException.toString());
            }
        }
    }

    public PublicKey getPublicKey() {
        return this.P;
    }

    public byte[] getDER() {
        return this.J;
    }

    public byte[] getIssuerDER() {
        return this.A;
    }

    public byte[] getSubjectDER() {
        return this.U;
    }

    public DistinguishedName getSubjectName() {
        return this.Q;
    }

    public DistinguishedName getIssuerName() {
        return this.L;
    }

    public Date getValidityNotBefore() {
        return this.H;
    }

    public Date getValidityNotAfter() {
        return this.T;
    }

    public Vector getExtensions() {
        return this.S;
    }

    public BigInteger getSerial() {
        return this.F;
    }

    void A(PublicKey publicKey, String string) throws CertificateVerifyException {
        if (string.equals("MD2/RSA") || string.equals("MD4/RSA") || string.equals("MD5/RSA") || string.equals("SHA-1/RSA/PKCS#1")) {
            if (!(publicKey instanceof CryptixRSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string, this);
            }
        } else if (string.equals("DSA")) {
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string, this);
            }
        } else {
            throw new CertificateVerifyException("Unknown algorithm " + string, this);
        }
    }

    public boolean verify(PublicKey publicKey) throws CertificateException {
        try {
            String string = (String)C.get(this.K);
            if (string != null) {
                SSLDebug.debug(32, "OID " + this.K + "mapped to " + string);
            }
            this.A(publicKey, string);
            String string2 = string != null ? string : this.K;
            Signature signature = Signature.getInstance(string2, "CryptixEDT");
            I.debug("verify: alg=" + string2 + ",provider=" + signature.getProvider().getName());
            signature.initVerify(publicKey);
            signature.update(this.R);
            return signature.verify(this.M);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            I.error("verify", noSuchProviderException);
            throw new CertificateVerifyException(noSuchProviderException.toString(), this);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            I.error("verify", noSuchAlgorithmException);
            throw new CertificateVerifyException(noSuchAlgorithmException.toString(), this);
        }
        catch (SignatureException signatureException) {
            I.error("verify", signatureException);
            throw new CertificateVerifyException(signatureException.toString(), this);
        }
        catch (InvalidKeyException invalidKeyException) {
            I.error("verify", invalidKeyException);
            return false;
        }
    }

    public static Vector verifyCertChain(CertContext certContext, Vector vector, CertVerifyPolicyInt certVerifyPolicyInt) throws IOException {
        int n2 = vector.size();
        Vector<X509Cert> vector2 = new Vector<X509Cert>();
        X509Cert x509Cert = null;
        boolean bl = false;
        int n3 = 255;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            X509Cert x509Cert2 = (X509Cert)vector.elementAt(i2);
            SSLDebug.debug(32, "Trying to verify", x509Cert2.getDER());
            if (!bl) {
                if (certContext.isRoot(x509Cert2.getDER())) {
                    SSLDebug.debug(32, "Is root");
                    x509Cert = x509Cert2;
                    vector2.addElement(x509Cert);
                    bl = true;
                    continue;
                }
                SSLDebug.debug(32, "Trying to find root with DN", x509Cert2.getIssuerDER());
                x509Cert = certContext.signedByRoot(x509Cert2.getIssuerDER());
                if (x509Cert == null) {
                    SSLDebug.debug(32, "Nope");
                    continue;
                }
                SSLDebug.debug(32, "Found one");
                vector2.addElement(x509Cert);
                bl = true;
            }
            if (!ArrayUtil.areEqual(x509Cert.getSubjectDER(), x509Cert2.getIssuerDER())) {
                String string = x509Cert2.getSubjectName().getNameString();
                throw new CertificateVerifyException("Invalid certificate chain at '" + string + "' certificate. Subject and issuer names do not" + " match", vector);
            }
            if (!x509Cert2.verify(x509Cert.getPublicKey())) {
                String string = x509Cert2.getSubjectName().getNameString();
                throw new CertificateVerifyException("The signature of '" + string + "' certificate does not match its issuer", vector);
            }
            if (certVerifyPolicyInt.checkDatesP()) {
                X509Cert.A(x509Cert2, new Date());
            }
            if (vector2.size() == 1) {
                n4 = x509Cert.A(false, certVerifyPolicyInt.requireBasicConstraintsCriticalP(), certVerifyPolicyInt.allowBasicConstraintsInNonCAP());
                if (++n4 != -1) {
                    n3 = n4;
                }
                x509Cert.A(false);
            } else {
                n4 = x509Cert.A(certVerifyPolicyInt.requireBasicConstraintsP(), certVerifyPolicyInt.requireBasicConstraintsCriticalP(), certVerifyPolicyInt.allowBasicConstraintsInNonCAP());
                if (++n4 < n3) {
                    n3 = n4;
                }
                x509Cert.A(certVerifyPolicyInt.requireKeyUsageP());
            }
            if (n3 < 1) {
                throw new CertificateVerifyException("No more certificates allowed. Ran out of pathLen", vector);
            }
            --n3;
            x509Cert = x509Cert2;
            vector2.addElement(x509Cert2);
        }
        if (x509Cert != null) {
            return vector2;
        }
        return null;
    }

    static void A(Certificate certificate, Date date) throws CertificateVerifyException {
        Date date2 = certificate.getValidityNotBefore();
        if (date.before(date2)) {
            String string = certificate.getSubjectName().getNameString();
            throw new CertificateVerifyException("Certificate '" + string + "' not yet valid. Not before date " + date2, certificate);
        }
        Date date3 = certificate.getValidityNotAfter();
        if (date.after(date3)) {
            String string = certificate.getSubjectName().getNameString();
            throw new CertificateVerifyException("Certificate '" + string + "' expired. Not after date " + date3, certificate);
        }
    }

    private int A(boolean bl, boolean bl2, boolean bl3) throws CertificateVerifyException {
        D d2 = null;
        try {
            X509Ext x509Ext = X509Ext.A(this, com.enterprisedt.net.puretls.cert.D.B);
            if (x509Ext != null) {
                d2 = new D(x509Ext);
            }
        }
        catch (IOException iOException) {
            throw new CertificateVerifyException("Problem parsing Basic Constraints" + iOException.toString(), this);
        }
        if (d2 != null) {
            if (d2.B()) {
                if (bl2 && !d2.C()) {
                    throw new CertificateVerifyException("Basic constraints for a CA must be critical", this);
                }
                return d2.A();
            }
            if (!bl3) {
                throw new CertificateVerifyException("Basic Constraints present in signing cert but not a CA", this);
            }
            return d2.A();
        }
        if (bl) {
            throw new CertificateVerifyException("Basic Constraints not present", this);
        }
        return 255;
    }

    private void A(boolean bl) throws CertificateVerifyException {
        A a2 = null;
        try {
            X509Ext x509Ext = X509Ext.A(this, com.enterprisedt.net.puretls.cert.A.C);
            if (x509Ext != null) {
                a2 = new A(x509Ext);
            }
        }
        catch (IOException iOException) {
            throw new CertificateVerifyException("Problem parsing Key Usage" + iOException.toString(), this);
        }
        if (a2 == null) {
            if (bl) {
                throw new CertificateVerifyException("Key Usage required for CAs", this);
            }
        } else if (!a2.A(com.enterprisedt.net.puretls.cert.A.G)) {
            throw new CertificateVerifyException("Key Usage present but keyCertSign not asserted", this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        C.put("1.2.840.10040.4.3", "DSA");
        C.put("1.2.840.113549.1.1.2", "MD2/RSA");
        C.put("1.2.840.113549.1.1.3", "MD4/RSA");
        C.put("1.2.840.113549.1.1.4", "MD5/RSA");
        C.put("1.2.840.113549.1.1.5", "SHA-1/RSA/PKCS#1");
    }
}

