/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFile {
    private static Logger A = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$SshPublicKeyFile == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$SshPublicKeyFile = SshPublicKeyFile.class$("com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFile")) : class$com$enterprisedt$net$j2ssh$transport$publickey$SshPublicKeyFile);
    private SshPublicKeyFormat C;
    private byte[] B;
    private String D;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$SshPublicKeyFile;

    protected SshPublicKeyFile(byte[] byArray, SshPublicKeyFormat sshPublicKeyFormat) {
        this.B = byArray;
        this.C = sshPublicKeyFormat;
    }

    public byte[] getBytes() {
        return this.C.formatKey(this.B);
    }

    public String getComment() {
        return this.D;
    }

    public void setComment(String string) {
        this.D = string;
    }

    public byte[] getKeyBlob() {
        return this.B;
    }

    public static SshPublicKeyFile create(SshPublicKey sshPublicKey, SshPublicKeyFormat sshPublicKeyFormat) {
        SshPublicKeyFile sshPublicKeyFile = new SshPublicKeyFile(sshPublicKey.getEncoded(), sshPublicKeyFormat);
        sshPublicKeyFile.setComment(sshPublicKeyFormat.getComment());
        return sshPublicKeyFile;
    }

    public static SshPublicKeyFile parse(File file) throws InvalidSshKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(fileInputStream);
        fileInputStream.close();
        return sshPublicKeyFile;
    }

    public static SshPublicKeyFile parse(InputStream inputStream) throws InvalidSshKeyException, IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        return SshPublicKeyFile.parse(byArray);
    }

    public static SshPublicKeyFile parse(byte[] byArray) throws InvalidSshKeyException {
        Object object;
        A.debug("Parsing public key file");
        SshPublicKeyFormat sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(SshPublicKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPublicKeyFormat.isFormatted(byArray);
        if (!bl) {
            A.debug("Public key is not in the default format, attempting parse with other supported formats");
            object = SshPublicKeyFormatFactory.getSupportedFormats().iterator();
            while (object.hasNext() && !bl) {
                String string = (String)object.next();
                A.debug("Attempting " + string);
                sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(string);
                bl = sshPublicKeyFormat.isFormatted(byArray);
            }
        }
        if (bl) {
            object = new SshPublicKeyFile(sshPublicKeyFormat.getKeyBlob(byArray), sshPublicKeyFormat);
            ((SshPublicKeyFile)object).setComment(sshPublicKeyFormat.getComment());
            return object;
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public String getAlgorithm() {
        return ByteArrayReader.readString(this.B, 0);
    }

    public void setFormat(SshPublicKeyFormat sshPublicKeyFormat) throws InvalidSshKeyException {
        if (!sshPublicKeyFormat.supportsAlgorithm(this.getAlgorithm())) {
            throw new InvalidSshKeyException("The format does not support the public key algorithm");
        }
        sshPublicKeyFormat.setComment(this.C.getComment());
        this.C = sshPublicKeyFormat;
    }

    public SshPublicKeyFormat getFormat() {
        return this.C;
    }

    public SshPublicKey toPublicKey() throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.B);
        String string = byteArrayReader.readString();
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
        return sshKeyPair.decodePublicKey(this.B);
    }

    public String toString() {
        return new String(this.C.formatKey(this.B));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

