/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationException;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SshKeyPairFactory {
    private static Map A;
    private static ArrayList B;
    private static String D;
    private static Logger C;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$SshKeyPairFactory;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssKeyPair;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaKeyPair;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$configuration$SshAPIConfiguration;

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return D;
    }

    public static List getSupportedKeys() {
        return new ArrayList(A.keySet());
    }

    public static List getEnabledKeyPairs() {
        return B;
    }

    public static void disableAllKeys() {
        B.clear();
    }

    public static void setKeyEnabled(String string, boolean bl) throws AlgorithmNotSupportedException {
        if (!A.containsKey(string)) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
        if (bl) {
            B.add(string);
        } else {
            B.remove(string);
        }
    }

    public static boolean isKeyEnabled(String string) {
        return B.contains(string);
    }

    public static SshKeyPair newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)A.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!", exception);
        }
    }

    public static boolean supportsKey(String string) {
        return A.containsKey(string);
    }

    public static SshPrivateKey decodePrivateKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    public static SshPublicKey decodePublicKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        C = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$SshKeyPairFactory == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$SshKeyPairFactory = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory")) : class$com$enterprisedt$net$j2ssh$transport$publickey$SshKeyPairFactory);
        A = new HashMap();
        C.debug("Loading public key algorithms");
        A.put("ssh-dss", class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssKeyPair == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssKeyPair = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssKeyPair")) : class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssKeyPair);
        A.put("ssh-rsa", class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaKeyPair == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaKeyPair = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair")) : class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaKeyPair);
        try {
            if (!ConfigurationLoader.isConfigurationAvailable(class$com$enterprisedt$net$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$enterprisedt$net$j2ssh$configuration$SshAPIConfiguration = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.configuration.SshAPIConfiguration")) : class$com$enterprisedt$net$j2ssh$configuration$SshAPIConfiguration)) {
                // empty if block
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (D == null || !A.containsKey(D)) {
            C.debug("The default public key is not set! using first in list");
            Iterator iterator = A.keySet().iterator();
            D = (String)iterator.next();
        }
        B = new ArrayList(A.keySet());
    }
}

