/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.util.Base64;

public class OpenSSHPublicKeyFormat
implements SshPublicKeyFormat {
    String L = null;

    public OpenSSHPublicKeyFormat(String string) {
        this.setComment(string);
    }

    public OpenSSHPublicKeyFormat() {
    }

    public void setComment(String string) {
        this.L = string;
    }

    public String getComment() {
        return this.L;
    }

    public String getFormatType() {
        return "OpenSSH-PublicKey";
    }

    public byte[] getKeyBlob(byte[] byArray) throws InvalidSshKeyException {
        int n2;
        String string;
        String string2 = new String(byArray);
        int n3 = string2.indexOf(" ");
        if (n3 > 0 && this.supportsAlgorithm(string = string2.substring(0, n3)) && (n2 = string2.indexOf(" ", n3 + 1)) > n3) {
            String string3 = string2.substring(n3 + 1, n2);
            if (string2.length() > n2) {
                this.L = string2.substring(n2 + 1).trim();
            }
            return Base64.decode(string3);
        }
        throw new InvalidSshKeyException("Failed to read OpenSSH key format");
    }

    public byte[] formatKey(byte[] byArray) {
        String string = ByteArrayReader.readString(byArray, 0);
        String string2 = string + " " + Base64.encodeBytes(byArray, true);
        if (this.L != null) {
            string2 = string2 + " " + this.L;
        }
        return string2.getBytes();
    }

    public boolean isFormatted(byte[] byArray) {
        String string = new String(byArray).trim();
        return string.startsWith("ssh-dss") || string.startsWith("ssh-rsa");
    }

    public boolean supportsAlgorithm(String string) {
        return string.equals("ssh-dss") || string.equals("ssh-rsa");
    }
}

