/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotAgreedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.MessageAlreadyRegisteredException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgKexInit;
import com.enterprisedt.net.j2ssh.transport.SshMsgServiceRequest;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolCommon;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipher;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipherFactory;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompression;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompressionFactory;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmac;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmacFactory;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransportProtocolClient
extends TransportProtocolCommon {
    protected SshPublicKey pk;
    private HostKeyVerification Q;
    private Map S = new HashMap();
    private SshMessageStore R = new SshMessageStore();
    private String T;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgServiceAccept;

    public TransportProtocolClient(HostKeyVerification hostKeyVerification, SshConnectionProperties sshConnectionProperties) throws TransportProtocolException {
        Object object;
        this.Q = hostKeyVerification;
        this.properties = sshConnectionProperties;
        try {
            object = InetAddress.getByName(sshConnectionProperties.getHost());
            this.T = !((InetAddress)object).getHostAddress().equals(sshConnectionProperties.getHost()) ? ((InetAddress)object).getHostName() + "," + ((InetAddress)object).getHostAddress() : ((InetAddress)object).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.debug("The host " + sshConnectionProperties.getHost() + " could not be resolved");
            this.T = sshConnectionProperties.getHost();
        }
        object = hostKeyVerification.getPreferredKeyAlgorithm(this.T);
        if (object != null) {
            sshConnectionProperties.setPrefPublicKey((String)object);
        }
    }

    public void onMessageReceived(SshMessage sshMessage) throws IOException {
        throw new IOException("No messages are registered");
    }

    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        this.R.registerMessage(6, class$com$enterprisedt$net$j2ssh$transport$SshMsgServiceAccept == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgServiceAccept = TransportProtocolClient.class$("com.enterprisedt.net.j2ssh.transport.SshMsgServiceAccept")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgServiceAccept);
        this.addMessageStore(this.R);
    }

    public void requestService(Service service) throws IOException {
        if (service.getState().getValue() != 1) {
            throw new IOException("The service instance must be uninitialized");
        }
        if (this.state.getValue() != 4 && this.state.getValue() != 3) {
            throw new IOException("The transport protocol is not connected");
        }
        try {
            this.state.waitForState(4);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The operation was interrupted", interruptedException);
        }
        service.init(1, this);
        this.S.put(service.getServiceName(), service);
        SshMessage sshMessage = new SshMsgServiceRequest(service.getServiceName());
        this.sendMessage(sshMessage, this);
        try {
            sshMessage = this.R.getMessage(6);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for a transport protocol message", interruptedException);
        }
    }

    protected void onDisconnect() {
        Iterator iterator = this.S.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((Service)entry.getValue()).stop();
        }
        this.S.clear();
    }

    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    protected String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    protected void setLocalIdent() {
        this.clientIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS + " [CLIENT]";
    }

    public String getLocalId() {
        return this.clientIdent;
    }

    protected void setLocalKexInit(SshMsgKexInit sshMsgKexInit) {
        this.clientKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getLocalKexInit() {
        return this.clientKexInit;
    }

    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    protected void setRemoteIdent(String string) {
        this.serverIdent = string;
    }

    public String getRemoteId() {
        return this.serverIdent;
    }

    protected void setRemoteKexInit(SshMsgKexInit sshMsgKexInit) {
        this.serverKexInit = sshMsgKexInit;
    }

    protected SshMsgKexInit getRemoteKexInit() {
        return this.serverKexInit;
    }

    public SshPublicKey getServerHostKey() {
        return this.pk;
    }

    protected void onStartTransportProtocol() throws IOException {
        while (this.state.getValue() != 4 && this.state.getValue() != 5) {
            try {
                this.state.waitForStateUpdate();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("The operation was interrupted");
            }
        }
        if (this.state.getValue() == 5) {
            if (this.state.hasError()) {
                throw this.state.getLastError();
            }
            throw new TransportProtocolException("The connection did not complete");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.properties.getHost());
            this.T = !inetAddress.getHostAddress().equals(this.properties.getHost()) ? inetAddress.getHostName() + "," + inetAddress.getHostAddress() : inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.debug("The host " + this.properties.getHost() + " could not be resolved");
            this.T = this.properties.getHost();
        }
    }

    protected void performKeyExchange(SshKeyExchange sshKeyExchange) throws IOException {
        sshKeyExchange.performClientExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.toByteArray());
        if (!this.verifyHostKey(sshKeyExchange.getHostKey(), sshKeyExchange.getSignature(), sshKeyExchange.getExchangeHash())) {
            String string = "The host signature is invalid or the host key was not accepted!";
            this.sendDisconnect(9, string, new KeyExchangeException(string));
            this.disconnect(string);
        }
    }

    protected void setupNewKeys(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        SshCipher sshCipher = SshCipherFactory.newInstance(this.getEncryptionAlgorithm());
        sshCipher.init(0, byArray2, byArray);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance(this.getDecryptionAlgorithm());
        sshCipher.init(1, byArray4, byArray3);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac sshHmac = SshHmacFactory.newInstance(this.getOutputStreamMacAlgorithm());
        sshHmac.init(byArray5);
        this.algorithmsOut.setHmac(sshHmac);
        sshHmac = SshHmacFactory.newInstance(this.getInputStreamMacAlgorithm());
        sshHmac.init(byArray6);
        this.algorithmsIn.setHmac(sshHmac);
        SshCompression sshCompression = SshCompressionFactory.newInstance(this.getInputStreamCompAlgorithm());
        if (sshCompression != null) {
            sshCompression.init(0, 0);
            this.algorithmsIn.setCompression(sshCompression);
        }
        if ((sshCompression = SshCompressionFactory.newInstance(this.getOutputStreamCompAlgorithm())) != null) {
            sshCompression.init(1, 6);
            this.algorithmsOut.setCompression(sshCompression);
        }
    }

    protected boolean verifyHostKey(byte[] byArray, byte[] byArray2, byte[] byArray3) throws TransportProtocolException {
        log.debug("Verifying host " + this.T);
        String string = this.Q.getPreferredKeyAlgorithm(this.T);
        log.debug("Preferred algorithm " + string);
        String string2 = this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys(), string);
        log.debug("Selected algorithm " + string2);
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string2);
        this.pk = sshKeyPair.setPublicKey(byArray);
        if (!this.pk.verifySignature(byArray2, byArray3)) {
            log.debug("The host signature is invalid");
            return false;
        }
        if (!this.Q.verifyHost(this.T, this.pk)) {
            log.debug("The host key is not accepted");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

