/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipherFactory;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompressionFactory;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmacFactory;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class SshMsgKexInit
extends SshMessage {
    protected static final int SSH_MSG_KEX_INIT = 20;
    private String z;
    private String r;
    private String p;
    private String t;
    private String v;
    private String \u00a2;
    private String s;
    private String x;
    private String y;
    private String w;
    private byte[] q;
    private boolean u;

    public SshMsgKexInit() {
        super(20);
    }

    public SshMsgKexInit(SshConnectionProperties sshConnectionProperties) {
        super(20);
        this.q = new byte[16];
        SecureRandom secureRandom = ConfigurationLoader.getRND();
        ((Random)secureRandom).nextBytes(this.q);
        this.v = this.createDelimString(this.A(SshKeyExchangeFactory.getEnabledKeyExchanges(), sshConnectionProperties.getPrefKex()));
        this.w = this.createDelimString(this.A(SshKeyPairFactory.getEnabledKeyPairs(), sshConnectionProperties.getPrefPublicKey()));
        this.p = this.createDelimString(this.A(SshCipherFactory.getEnabledCiphers(), sshConnectionProperties.getPrefCSEncryption()));
        this.t = this.createDelimString(this.A(SshCipherFactory.getEnabledCiphers(), sshConnectionProperties.getPrefSCEncryption()));
        this.x = this.createDelimString(this.A(SshHmacFactory.getEnabledMacs(), sshConnectionProperties.getPrefCSMac()));
        this.y = this.createDelimString(this.A(SshHmacFactory.getEnabledMacs(), sshConnectionProperties.getPrefSCMac()));
        this.z = this.createDelimString(this.A(SshCompressionFactory.getEnabledCompressions(), sshConnectionProperties.getPrefCSComp()));
        this.r = this.createDelimString(this.A(SshCompressionFactory.getEnabledCompressions(), sshConnectionProperties.getPrefSCComp()));
        this.\u00a2 = "";
        this.s = "";
        this.u = false;
    }

    public String getMessageName() {
        return "SSH_MSG_KEX_INIT";
    }

    public List getSupportedCSComp() {
        return this.A(this.z);
    }

    public List getSupportedCSEncryption() {
        return this.A(this.p);
    }

    public List getSupportedCSMac() {
        return this.A(this.x);
    }

    public List getSupportedKex() {
        return this.A(this.v);
    }

    public void setSupportedPK(List list) {
        this.w = this.createDelimString(list);
    }

    public List getSupportedPublicKeys() {
        return this.A(this.w);
    }

    public List getSupportedSCComp() {
        return this.A(this.r);
    }

    public List getSupportedSCEncryption() {
        return this.A(this.t);
    }

    public List getSupportedSCMac() {
        return this.A(this.y);
    }

    public String createDelimString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = super.toString() + "\n";
        string = string + "Supported Kex " + this.v.toString() + "\n";
        string = string + "Supported Public Keys " + this.w.toString() + "\n";
        string = string + "Supported Encryption Client->Server " + this.p.toString() + "\n";
        string = string + "Supported Encryption Server->Client " + this.t.toString() + "\n";
        string = string + "Supported Mac Client->Server " + this.x.toString() + "\n";
        string = string + "Supported Mac Server->Client " + this.y.toString() + "\n";
        string = string + "Supported Compression Client->Server " + this.z.toString() + "\n";
        string = string + "Supported Compression Server->Client " + this.r.toString() + "\n";
        string = string + "Supported Languages Client->Server " + this.\u00a2.toString() + "\n";
        string = string + "Supported Languages Server->Client " + this.s.toString() + "\n";
        string = string + "First Kex Packet Follows [" + (this.u ? "TRUE]" : "FALSE]");
        return string;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.write(this.q);
            byteArrayWriter.writeString(this.v);
            byteArrayWriter.writeString(this.w);
            byteArrayWriter.writeString(this.p);
            byteArrayWriter.writeString(this.t);
            byteArrayWriter.writeString(this.x);
            byteArrayWriter.writeString(this.y);
            byteArrayWriter.writeString(this.z);
            byteArrayWriter.writeString(this.r);
            byteArrayWriter.writeString(this.\u00a2);
            byteArrayWriter.writeString(this.s);
            byteArrayWriter.write(this.u ? 1 : 0);
            byteArrayWriter.writeInt(0);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data", iOException);
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.q = new byte[16];
            byteArrayReader.read(this.q);
            this.v = byteArrayReader.readString();
            this.w = byteArrayReader.readString();
            this.p = byteArrayReader.readString();
            this.t = byteArrayReader.readString();
            this.x = byteArrayReader.readString();
            this.y = byteArrayReader.readString();
            this.z = byteArrayReader.readString();
            this.r = byteArrayReader.readString();
            this.\u00a2 = byteArrayReader.readString();
            this.s = byteArrayReader.readString();
            this.u = byteArrayReader.read() != 0;
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error reading message data", iOException);
        }
    }

    private List A(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        if (string.endsWith(",")) {
            arrayList.add("");
        }
        return arrayList;
    }

    private List A(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        if (arrayList.contains(string)) {
            arrayList.remove(string);
            arrayList.add(0, string);
        }
        return arrayList;
    }
}

