/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.subsystem;

import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessageStore;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.util.StartStopState;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class SubsystemClient
implements Runnable {
    private static Logger C = Logger.getLogger(class$com$enterprisedt$net$j2ssh$subsystem$SubsystemClient == null ? (class$com$enterprisedt$net$j2ssh$subsystem$SubsystemClient = SubsystemClient.class$("com.enterprisedt.net.j2ssh.subsystem.SubsystemClient")) : class$com$enterprisedt$net$j2ssh$subsystem$SubsystemClient);
    private InputStream F;
    private OutputStream D;
    private Thread E;
    private String B;
    private StartStopState A = new StartStopState(2);
    protected SubsystemMessageStore messageStore;
    protected SessionChannelClient session;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$subsystem$SubsystemClient;

    public SubsystemClient(String string) {
        this.B = string;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemClient(String string, SubsystemMessageStore subsystemMessageStore) {
        this.B = string;
        this.messageStore = subsystemMessageStore;
    }

    public boolean isClosed() {
        return this.A.getValue() == 2;
    }

    public void setSessionChannel(SessionChannelClient sessionChannelClient) {
        this.session = sessionChannelClient;
        this.F = sessionChannelClient.getInputStream();
        this.D = sessionChannelClient.getOutputStream();
        sessionChannelClient.setName(this.B);
    }

    public SessionChannelClient getSessionChannel() {
        return this.session;
    }

    public boolean start() throws IOException {
        this.E = new SshThread(this, this.B + " subsystem", true);
        if (this.session == null) {
            throw new IOException("No valid session is attached to the subsystem!");
        }
        if (this.session.getState().getValue() != 2) {
            throw new IOException("The session is not open!");
        }
        this.E.start();
        return this.onStart();
    }

    protected abstract boolean onStart() throws IOException;

    public String getName() {
        return this.B;
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws InvalidMessageException, IOException {
        if (C.isDebugEnabled()) {
            C.debug("Sending " + subsystemMessage.getMessageName() + " subsystem message");
        }
        byte[] byArray = subsystemMessage.toByteArray();
        this.D.write(ByteArrayWriter.encodeInt(byArray.length));
        this.D.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[4];
        this.A.setValue(1);
        try {
            while (this.A.getValue() == 1 && this.session.getState().getValue() == 2) {
                int n2 = this.F.read(byArray);
                if (n2 > 0) {
                    int n3 = (int)ByteArrayReader.readInt(byArray, 0);
                    byte[] byArray2 = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        n2 = this.F.read(byArray2, n4, byArray2.length - n4);
                        if (n2 > 0) {
                            n4 += n2;
                            continue;
                        }
                        if (n2 != -1) continue;
                    }
                    this.messageStore.addMessage(byArray2);
                    byArray2 = null;
                    continue;
                }
                if (n2 != -1) continue;
                break;
            }
        }
        catch (IOException iOException) {
            C.fatal("Subsystem message loop failed!", iOException);
        }
        finally {
            this.A.setValue(2);
        }
        this.E = null;
    }

    public void stop() throws IOException {
        this.A.setValue(2);
        this.F.close();
        this.D.close();
        this.session.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

