/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;

public class SftpFile
implements Comparable {
    private String B;
    private byte[] E;
    private FileAttributes C;
    private SftpSubsystemClient D;
    private String A;

    public SftpFile(String string, FileAttributes fileAttributes) {
        this.A = string;
        int n2 = string.lastIndexOf("/");
        this.B = n2 > -1 ? string.substring(n2 + 1) : string;
        this.C = fileAttributes;
    }

    public SftpFile(String string) {
        this(string, new FileAttributes());
    }

    public boolean canWrite() {
        return (this.getAttributes().getPermissions().longValue() & 0x80L) == 128L;
    }

    public boolean canRead() {
        return (this.getAttributes().getPermissions().longValue() & 0x100L) == 256L;
    }

    public boolean isOpen() {
        if (this.D == null) {
            return false;
        }
        return this.D.isValidHandle(this.E);
    }

    protected void setHandle(byte[] byArray) {
        this.E = byArray;
    }

    protected byte[] getHandle() {
        return this.E;
    }

    protected void setSFTPSubsystem(SftpSubsystemClient sftpSubsystemClient) {
        this.D = sftpSubsystemClient;
    }

    protected SftpSubsystemClient getSFTPSubsystem() {
        return this.D;
    }

    public String getFilename() {
        return this.B;
    }

    private String A(int n2) {
        String string = "";
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                string = string + " ";
            }
        }
        return string;
    }

    public String getLongname() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.A(10 - this.getAttributes().getPermissionsString().length()) + this.getAttributes().getPermissionsString());
        stringBuffer.append("   1 ");
        stringBuffer.append(this.getAttributes().getUID().toString() + this.A(8 - this.getAttributes().getUID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getAttributes().getGID().toString() + this.A(8 - this.getAttributes().getGID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.A(8 - this.getAttributes().getSize().toString().length()) + this.getAttributes().getSize().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.A(12 - this.getAttributes().getModTimeString().length()) + this.getAttributes().getModTimeString());
        stringBuffer.append(" ");
        stringBuffer.append(this.B);
        return stringBuffer.toString();
    }

    public FileAttributes getAttributes() {
        try {
            if (this.C == null) {
                this.C = this.D.getAttributes(this);
            }
        }
        catch (Exception exception) {
            this.C = new FileAttributes();
        }
        return this.C;
    }

    public String getAbsolutePath() {
        return this.A;
    }

    public void close() throws IOException {
        this.D.closeFile(this);
    }

    public boolean isDirectory() {
        return (this.getAttributes().getPermissions().intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        return (this.getAttributes().getPermissions().intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        return (this.getAttributes().getPermissions().intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        return (this.getAttributes().getPermissions().intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        return (this.getAttributes().getPermissions().intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        return (this.getAttributes().getPermissions().intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        return (this.getAttributes().getPermissions().intValue() & 0xC000) == 49152;
    }

    public int compareTo(Object object) {
        return this.getFilename().compareTo(((SftpFile)object).getFilename());
    }
}

