/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.openssh.PEM;
import com.enterprisedt.net.j2ssh.util.Base64;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

public class PEMReader
extends PEM {
    private LineNumberReader E;
    private String F;
    private Map H;
    private byte[] G;

    public PEMReader(Reader reader) throws IOException {
        this.E = new LineNumberReader(reader);
        this.A();
    }

    private void A() throws IOException {
        int n2;
        String string;
        while ((string = this.E.readLine()) != null) {
            if (!string.startsWith("-----") || !string.endsWith("-----")) continue;
            if (string.startsWith("-----BEGIN ")) {
                this.F = string.substring("-----BEGIN ".length(), string.length() - "-----".length());
                break;
            }
            throw new IOException("Invalid PEM boundary at line " + this.E.getLineNumber() + ": " + string);
        }
        this.H = new HashMap();
        block1: while ((string = this.E.readLine()) != null && (n2 = string.indexOf(58)) != -1) {
            String string2;
            String string3 = string.substring(0, n2).trim();
            if (string.endsWith("\\")) {
                string2 = string.substring(n2 + 1, string.length() - 1).trim();
                StringBuffer stringBuffer = new StringBuffer(string2);
                while ((string = this.E.readLine()) != null) {
                    if (string.endsWith("\\")) {
                        stringBuffer.append(" ").append(string.substring(0, string.length() - 1).trim());
                        continue;
                    }
                    stringBuffer.append(" ").append(string.trim());
                    continue block1;
                }
                continue;
            }
            string2 = string.substring(n2 + 1).trim();
            this.H.put(string3, string2);
        }
        if (string == null) {
            throw new IOException("The key format is invalid! OpenSSH formatted keys must begin with -----BEGIN RSA or -----BEGIN DSA");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((string = this.E.readLine()) != null) {
            if (string.startsWith("-----") && string.endsWith("-----")) {
                if (string.startsWith("-----END " + this.F)) break;
                throw new IOException("Invalid PEM end boundary at line " + this.E.getLineNumber() + ": " + string);
            }
            stringBuffer.append(string);
        }
        this.G = Base64.decode(stringBuffer.toString());
    }

    public Map getHeader() {
        return this.H;
    }

    public byte[] getPayload() {
        return this.G;
    }

    public String getType() {
        return this.F;
    }

    public byte[] decryptPayload(String string) throws GeneralSecurityException {
        String string2 = (String)this.H.get("DEK-Info");
        if (string2 != null) {
            int n2 = string2.indexOf(44);
            String string3 = string2.substring(0, n2);
            if (!"DES-EDE3-CBC".equals(string3)) {
                throw new NoSuchAlgorithmException("Unsupported passphrase algorithm: " + string3);
            }
            String string4 = string2.substring(n2 + 1);
            byte[] byArray = new byte[string4.length() / 2];
            for (int i2 = 0; i2 < string4.length(); i2 += 2) {
                byArray[i2 / 2] = (byte)Integer.parseInt(string4.substring(i2, i2 + 2), 16);
            }
            Cipher cipher = Cipher.getInstance("DESede/CBC/NONE", "CryptixEDT");
            Key key = PEMReader.getKeyFromPassphrase(string, byArray, 24);
            if (cipher instanceof FeedbackCipher) {
                ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray);
            }
            cipher.initDecrypt(key);
            byte[] byArray2 = new byte[this.G.length];
            cipher.update(this.G, 0, this.G.length, byArray2, 0);
            return byArray2;
        }
        return this.G;
    }
}

