/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelData
extends SshMessage {
    public static final int SSH_MSG_CHANNEL_DATA = 94;
    private byte[] L;
    private long K;

    public SshMsgChannelData(long l2, byte[] byArray) {
        super(94);
        this.K = l2;
        this.L = byArray;
    }

    public SshMsgChannelData() {
        super(94);
    }

    public byte[] getChannelData() {
        return this.L;
    }

    public long getChannelDataLength() {
        return this.L.length;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_DATA";
    }

    public long getRecipientChannel() {
        return this.K;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.K);
            if (this.L != null) {
                byteArrayWriter.writeBinaryString(this.L);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data", iOException);
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.K = byteArrayReader.readInt();
            if (byteArrayReader.available() > 0) {
                this.L = byteArrayReader.readBinaryString();
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data", iOException);
        }
    }
}

