/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelDataWindow;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelFactory;
import com.enterprisedt.net.j2ssh.connection.ChannelState;
import com.enterprisedt.net.j2ssh.connection.GlobalRequestHandler;
import com.enterprisedt.net.j2ssh.connection.GlobalRequestResponse;
import com.enterprisedt.net.j2ssh.connection.InvalidChannelException;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelClose;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelEOF;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpen;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelRequest;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelSuccess;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.enterprisedt.net.j2ssh.connection.SshMsgGlobalRequest;
import com.enterprisedt.net.j2ssh.connection.SshMsgRequestFailure;
import com.enterprisedt.net.j2ssh.connection.SshMsgRequestSuccess;
import com.enterprisedt.net.j2ssh.transport.AsyncService;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ConnectionProtocol
extends AsyncService {
    private static Logger L = Logger.getLogger(class$com$enterprisedt$net$j2ssh$connection$ConnectionProtocol == null ? (class$com$enterprisedt$net$j2ssh$connection$ConnectionProtocol = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.ConnectionProtocol")) : class$com$enterprisedt$net$j2ssh$connection$ConnectionProtocol);
    private HashSet K = new HashSet();
    private Map J = new HashMap();
    private Map M = new HashMap();
    private Map I = new HashMap();
    private long H = 0L;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$ConnectionProtocol;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenConfirmation;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenFailure;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpen;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelClose;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelEOF;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelData;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelExtendedData;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelFailure;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelRequest;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelSuccess;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelWindowAdjust;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgGlobalRequest;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestFailure;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestSuccess;

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String string, ChannelFactory channelFactory) throws IOException {
        this.M.put(string, channelFactory);
    }

    public void removeChannelFactory(String string) {
        this.M.remove(string);
    }

    public boolean containsChannelFactory(String string) {
        return this.M.containsKey(string);
    }

    public void allowGlobalRequest(String string, GlobalRequestHandler globalRequestHandler) {
        this.I.put(string, globalRequestHandler);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long A() {
        Map map = this.J;
        synchronized (map) {
            if (this.K.size() <= 0) {
                return new Long(this.H++);
            }
            return (Long)this.K.iterator().next();
        }
    }

    public synchronized boolean openChannel(Channel channel, ChannelEventListener channelEventListener) throws IOException {
        Map map = this.J;
        synchronized (map) {
            Long l2 = this.A();
            SshMsgChannelOpen sshMsgChannelOpen = new SshMsgChannelOpen(channel.getChannelType(), l2, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(sshMsgChannelOpen, this);
            int[] nArray = new int[]{91, 92};
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                if (sshMessage.getMessageId() == 91) {
                    SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = (SshMsgChannelOpenConfirmation)sshMessage;
                    this.J.put(l2, channel);
                    L.debug("Initiating channel");
                    channel.init(this, l2, sshMsgChannelOpenConfirmation.getSenderChannel(), sshMsgChannelOpenConfirmation.getInitialWindowSize(), sshMsgChannelOpenConfirmation.getMaximumPacketSize(), channelEventListener);
                    channel.open();
                    L.debug("Channel " + String.valueOf(channel.getLocalChannelId()) + " is open [" + channel.getName() + "]");
                    return true;
                }
                channel.getState().setValue(3);
                return false;
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                throw new IOException(messageStoreEOFException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
    }

    protected void onStop() {
        L.debug("Closing all active channels");
        try {
            Iterator iterator = this.J.values().iterator();
            while (iterator.hasNext()) {
                Channel channel = (Channel)iterator.next();
                if (channel == null) continue;
                if (L.isDebugEnabled()) {
                    L.debug("Closing " + channel.getName() + " id=" + String.valueOf(channel.getLocalChannelId()));
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.J.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendChannelData(Channel channel, byte[] byArray) throws IOException {
        ChannelState channelState = channel.getState();
        synchronized (channelState) {
            int n2;
            if (L.isDebugEnabled()) {
                L.debug("Sending " + String.valueOf(byArray.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId()));
            }
            ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
            for (int i2 = 0; i2 < byArray.length; i2 += n2) {
                int n3 = byArray.length - i2;
                long l2 = channelDataWindow.getWindowSpace() < channel.getRemotePacketSize() && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : channel.getRemotePacketSize();
                n2 = l2 < (long)n3 ? (int)l2 : n3;
                channel.remoteWindow.consumeWindowSpace(n2);
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, i2, byArray2, 0, n2);
                SshMsgChannelData sshMsgChannelData = new SshMsgChannelData(channel.getRemoteChannelId(), byArray2);
                this.transport.sendMessage(sshMsgChannelData, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.J;
        synchronized (map) {
            if (!this.J.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel " + String.valueOf(channel.getLocalChannelId()));
            }
            L.debug("Local computer has set channel " + String.valueOf(channel.getLocalChannelId()) + " to EOF [" + channel.getName() + "]");
            SshMsgChannelEOF sshMsgChannelEOF = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(sshMsgChannelEOF, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int n2, byte[] byArray) throws IOException {
        int n3;
        channel.getRemoteWindow().consumeWindowSpace(byArray.length);
        ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
        for (int i2 = 0; i2 < byArray.length; i2 += n3) {
            int n4 = byArray.length - i2;
            long l2 = channelDataWindow.getWindowSpace() < channel.getRemotePacketSize() && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : channel.getRemotePacketSize();
            n3 = l2 < (long)n4 ? (int)l2 : n4;
            channel.remoteWindow.consumeWindowSpace(n3);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i2, byArray2, 0, n3);
            SshMsgChannelExtendedData sshMsgChannelExtendedData = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), n2, byArray2);
            this.transport.sendMessage(sshMsgChannelExtendedData, this);
        }
    }

    public synchronized boolean sendChannelRequest(Channel channel, String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        L.debug("Sending " + string + " request for the " + channel.getChannelType() + " channel");
        SshMsgChannelRequest sshMsgChannelRequest = new SshMsgChannelRequest(channel.getRemoteChannelId(), string, bl, byArray);
        this.transport.sendMessage(sshMsgChannelRequest, this);
        if (bl) {
            int[] nArray = new int[]{99, 100};
            L.debug("Waiting for channel request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 99: {
                        L.debug("Channel request succeeded");
                        bl2 = true;
                        break;
                    }
                    case 100: {
                        L.debug("Channel request failed");
                        bl2 = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
        return bl2;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    public void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess sshMsgChannelSuccess = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelSuccess, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long l2) throws IOException {
        L.debug("Increasing window size by " + String.valueOf(l2) + " bytes");
        SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), l2);
        this.transport.sendMessage(sshMsgChannelWindowAdjust, this);
    }

    public synchronized byte[] sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        SshMsgGlobalRequest sshMsgGlobalRequest = new SshMsgGlobalRequest(string, true, byArray);
        this.transport.sendMessage(sshMsgGlobalRequest, this);
        if (bl) {
            int[] nArray = new int[]{81, 82};
            L.debug("Waiting for global request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 81: {
                        L.debug("Global request succeeded");
                        return ((SshMsgRequestSuccess)sshMessage).getRequestData();
                    }
                    case 82: {
                        L.debug("Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message", interruptedException);
            }
        }
        return null;
    }

    protected int[] getAsyncMessageFilter() {
        int[] nArray = new int[10];
        nArray[0] = 80;
        nArray[3] = 90;
        nArray[4] = 97;
        nArray[5] = 96;
        nArray[6] = 95;
        nArray[7] = 94;
        nArray[8] = 98;
        nArray[9] = 93;
        return nArray;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose sshMsgChannelClose = new SshMsgChannelClose(channel.getRemoteChannelId());
        L.debug("Local computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        this.transport.sendMessage(sshMsgChannelClose, this);
    }

    protected void onGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        L.debug("Processing " + string + " global request");
        if (!this.I.containsKey(string)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler globalRequestHandler = (GlobalRequestHandler)this.I.get(string);
            GlobalRequestResponse globalRequestResponse = globalRequestHandler.processGlobalRequest(string, byArray);
            if (bl) {
                if (globalRequestResponse.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(globalRequestResponse.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 80: {
                this.A((SshMsgGlobalRequest)sshMessage);
                break;
            }
            case 90: {
                this.A((SshMsgChannelOpen)sshMessage);
                break;
            }
            case 97: {
                this.A((SshMsgChannelClose)sshMessage);
                break;
            }
            case 96: {
                this.A((SshMsgChannelEOF)sshMessage);
                break;
            }
            case 94: {
                this.A((SshMsgChannelData)sshMessage);
                break;
            }
            case 95: {
                this.A((SshMsgChannelExtendedData)sshMessage);
                break;
            }
            case 98: {
                this.A((SshMsgChannelRequest)sshMessage);
                break;
            }
            case 93: {
                this.A((SshMsgChannelWindowAdjust)sshMessage);
                break;
            }
            default: {
                L.debug("Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    protected void onServiceAccept() {
    }

    protected void onServiceInit(int n2) throws IOException {
        L.debug("Registering connection protocol messages");
        this.messageStore.registerMessage(91, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenConfirmation == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenConfirmation = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenConfirmation")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenConfirmation);
        this.messageStore.registerMessage(92, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenFailure == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenFailure = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpenFailure")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpenFailure);
        this.messageStore.registerMessage(90, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpen == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpen = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelOpen")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelOpen);
        this.messageStore.registerMessage(97, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelClose == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelClose = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelClose")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelClose);
        this.messageStore.registerMessage(96, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelEOF == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelEOF = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelEOF")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelEOF);
        this.messageStore.registerMessage(94, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelData == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelData = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelData")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelData);
        this.messageStore.registerMessage(95, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelExtendedData == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelExtendedData = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelExtendedData);
        this.messageStore.registerMessage(100, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelFailure == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelFailure = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelFailure")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelFailure);
        this.messageStore.registerMessage(98, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelRequest == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelRequest = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelRequest")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelRequest);
        this.messageStore.registerMessage(99, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelSuccess == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelSuccess = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelSuccess")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelSuccess);
        this.messageStore.registerMessage(93, class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelWindowAdjust == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelWindowAdjust = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgChannelWindowAdjust")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgChannelWindowAdjust);
        this.messageStore.registerMessage(80, class$com$enterprisedt$net$j2ssh$connection$SshMsgGlobalRequest == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgGlobalRequest = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgGlobalRequest")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgGlobalRequest);
        this.messageStore.registerMessage(82, class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestFailure == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestFailure = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgRequestFailure")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestFailure);
        this.messageStore.registerMessage(81, class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestSuccess == null ? (class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestSuccess = ConnectionProtocol.class$("com.enterprisedt.net.j2ssh.connection.SshMsgRequestSuccess")) : class$com$enterprisedt$net$j2ssh$connection$SshMsgRequestSuccess);
    }

    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(sshMsgChannelOpenConfirmation, this);
    }

    protected void sendChannelOpenFailure(long l2, long l3, String string, String string2) throws IOException {
        SshMsgChannelOpenFailure sshMsgChannelOpenFailure = new SshMsgChannelOpenFailure(l2, l3, string, string2);
        this.transport.sendMessage(sshMsgChannelOpenFailure, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure sshMsgRequestFailure = new SshMsgRequestFailure();
        this.transport.sendMessage(sshMsgRequestFailure, this);
    }

    protected void sendGlobalRequestSuccess(byte[] byArray) throws IOException {
        SshMsgRequestSuccess sshMsgRequestSuccess = new SshMsgRequestSuccess(byArray);
        this.transport.sendMessage(sshMsgRequestSuccess, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel A(long l2) throws IOException {
        Map map = this.J;
        synchronized (map) {
            Long l3 = new Long(l2);
            if (!this.J.containsKey(l3)) {
                throw new IOException("Non existent channel " + l3.toString() + " requested");
            }
            return (Channel)this.J.get(l3);
        }
    }

    private void A(SshMsgChannelClose sshMsgChannelClose) throws IOException {
        Channel channel = this.A(sshMsgChannelClose.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel " + String.valueOf(sshMsgChannelClose.getRecipientChannel()));
        }
        L.debug("Remote computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]");
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void A(SshMsgChannelData sshMsgChannelData) throws IOException {
        if (L.isDebugEnabled()) {
            L.debug("Received " + String.valueOf(sshMsgChannelData.getChannelData().length) + " bytes of data for channel id " + String.valueOf(sshMsgChannelData.getRecipientChannel()));
        }
        Channel channel = this.A(sshMsgChannelData.getRecipientChannel());
        channel.processChannelData(sshMsgChannelData);
    }

    private void A(SshMsgChannelEOF sshMsgChannelEOF) throws IOException {
        Channel channel = this.A(sshMsgChannelEOF.getRecipientChannel());
        try {
            L.debug("Remote computer has set channel " + String.valueOf(sshMsgChannelEOF.getRecipientChannel()) + " to EOF [" + channel.getName() + "]");
            channel.setRemoteEOF();
        }
        catch (IOException iOException) {
            L.debug("Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void A(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        Channel channel = this.A(sshMsgChannelExtendedData.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.processChannelData(sshMsgChannelExtendedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(SshMsgChannelOpen sshMsgChannelOpen) throws IOException {
        Map map = this.J;
        synchronized (map) {
            L.debug("Request for " + sshMsgChannelOpen.getChannelType() + " channel recieved");
            ChannelFactory channelFactory = (ChannelFactory)this.M.get(sshMsgChannelOpen.getChannelType());
            if (channelFactory == null) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, "The channel type is not supported", "");
                L.debug("Request for channel type " + sshMsgChannelOpen.getChannelType() + " refused");
                return;
            }
            try {
                L.debug("Creating channel " + sshMsgChannelOpen.getChannelType());
                Channel channel = channelFactory.createChannel(sshMsgChannelOpen.getChannelType(), sshMsgChannelOpen.getChannelData());
                L.debug("Initiating channel");
                Long l2 = this.A();
                channel.init(this, l2, sshMsgChannelOpen.getSenderChannelId(), sshMsgChannelOpen.getInitialWindowSize(), sshMsgChannelOpen.getMaximumPacketSize());
                this.J.put(l2, channel);
                L.debug("Sending channel open confirmation");
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException invalidChannelException) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, invalidChannelException.getMessage(), "");
            }
        }
    }

    private void A(SshMsgChannelRequest sshMsgChannelRequest) throws IOException {
        Channel channel = this.A(sshMsgChannelRequest.getRecipientChannel());
        if (channel == null) {
            L.warn("Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(sshMsgChannelRequest.getRequestType(), sshMsgChannelRequest.getWantReply(), sshMsgChannelRequest.getChannelData());
    }

    private void A(SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust) throws IOException {
        Channel channel = this.A(sshMsgChannelWindowAdjust.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for non existent channel " + String.valueOf(sshMsgChannelWindowAdjust.getRecipientChannel()));
        }
        channel.getRemoteWindow().increaseWindowSpace(sshMsgChannelWindowAdjust.getBytesToAdd());
        if (L.isDebugEnabled()) {
            L.debug(String.valueOf(sshMsgChannelWindowAdjust.getBytesToAdd()) + " bytes added to remote window");
            L.debug("Remote window space is " + String.valueOf(channel.getRemoteWindow().getWindowSpace()));
        }
    }

    private void A(SshMsgGlobalRequest sshMsgGlobalRequest) throws IOException {
        this.onGlobalRequest(sshMsgGlobalRequest.getRequestName(), sshMsgGlobalRequest.getWantReply(), sshMsgGlobalRequest.getRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(Channel channel) {
        Map map = this.J;
        synchronized (map) {
            L.debug("Freeing channel " + String.valueOf(channel.getLocalChannelId()) + " [" + channel.getName() + "]");
            Long l2 = new Long(channel.getLocalChannelId());
            this.J.remove(l2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

