/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.connection.ChannelDataWindow;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelState;
import com.enterprisedt.net.j2ssh.connection.ConnectionProtocol;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class Channel {
    private static Logger E = Logger.getLogger(class$com$enterprisedt$net$j2ssh$connection$Channel == null ? (class$com$enterprisedt$net$j2ssh$connection$Channel = Channel.class$("com.enterprisedt.net.j2ssh.connection.Channel")) : class$com$enterprisedt$net$j2ssh$connection$Channel);
    protected ChannelDataWindow localWindow = new ChannelDataWindow();
    protected ChannelDataWindow remoteWindow = new ChannelDataWindow();
    protected ConnectionProtocol connection;
    protected long localChannelId;
    protected long localPacketSize;
    protected long remoteChannelId;
    protected long remotePacketSize;
    protected ChannelState state = new ChannelState();
    private boolean G = false;
    private boolean F = false;
    private boolean D = false;
    private boolean A = false;
    private String C = "Unnamed Channel";
    private Vector B = new Vector();
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$connection$Channel;

    public Channel() {
        this.localPacketSize = this.getMaximumPacketSize();
        this.localWindow.increaseWindowSpace(this.getMaximumWindowSpace());
    }

    public abstract byte[] getChannelOpenData();

    public abstract byte[] getChannelConfirmationData();

    public abstract String getChannelType();

    protected abstract int getMinimumWindowSpace();

    protected abstract int getMaximumWindowSpace();

    protected abstract int getMaximumPacketSize();

    protected abstract void onChannelData(SshMsgChannelData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (!this.isClosed()) {
                if (sshMsgChannelData.getChannelDataLength() > this.localWindow.getWindowSpace()) {
                    throw new IOException("More data received than is allowed by the channel data window [" + this.C + "]");
                }
                long l2 = this.localWindow.consumeWindowSpace(sshMsgChannelData.getChannelData().length);
                if (l2 < (long)this.getMinimumWindowSpace()) {
                    if (E.isDebugEnabled()) {
                        E.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.C + "]");
                    }
                    l2 = (long)this.getMaximumWindowSpace() - l2;
                    E.debug("Requesting connection protocol increase window");
                    this.connection.sendChannelWindowAdjust(this, l2);
                    this.localWindow.increaseWindowSpace(l2);
                }
                this.onChannelData(sshMsgChannelData);
                Iterator iterator = this.B.iterator();
                while (iterator.hasNext()) {
                    ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                    if (channelEventListener == null) continue;
                    channelEventListener.onDataReceived(this, sshMsgChannelData.getChannelData());
                }
            } else {
                throw new IOException("Channel data received but channel is closed [" + this.C + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 2;
        }
    }

    protected void sendChannelData(byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.C + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelData(this, byArray);
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed [" + this.C + "]");
        }
    }

    protected void sendChannelExtData(int n2, byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.C + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelExtData(this, n2, byArray);
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed [" + this.C + "]");
        }
    }

    protected abstract void onChannelExtData(SshMsgChannelExtendedData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if ((long)sshMsgChannelExtendedData.getChannelData().length > this.localWindow.getWindowSpace()) {
                E.error("Window space=" + this.localWindow.getWindowSpace() + ", data length=" + sshMsgChannelExtendedData.getChannelData().length);
                throw new IOException("More data received than is allowed by the channel data window [" + this.C + "]");
            }
            long l2 = this.localWindow.consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
            if (l2 < (long)this.getMinimumWindowSpace()) {
                if (E.isDebugEnabled()) {
                    E.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.C + "]");
                }
                l2 = (long)this.getMaximumWindowSpace() - l2;
                this.connection.sendChannelWindowAdjust(this, l2);
                this.localWindow.increaseWindowSpace(l2);
            }
            this.onChannelExtData(sshMsgChannelExtendedData);
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataReceived(this, sshMsgChannelExtendedData.getChannelData());
            }
        }
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public long getLocalPacketSize() {
        return this.localPacketSize;
    }

    public ChannelDataWindow getLocalWindow() {
        return this.localWindow;
    }

    public long getRemoteChannelId() {
        return this.remoteChannelId;
    }

    public long getRemotePacketSize() {
        return this.remotePacketSize;
    }

    public ChannelDataWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    public ChannelState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (this.isOpen()) {
                if (this.connection != null && !this.D && this.connection.isConnected()) {
                    this.connection.closeChannel(this);
                }
                this.D = true;
                if (E.isDebugEnabled()) {
                    E.debug("Connection is " + (this.connection == null ? "null" : (this.connection.isConnected() ? "connected" : "not connected")));
                }
                if (this.A || this.connection == null || !this.connection.isConnected()) {
                    E.debug("Finalizing channel close");
                    this.finalizeClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteClose() throws IOException {
        E.debug("Remote side is closing channel");
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.A = true;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeClose() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(3);
            this.onChannelClose();
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelClose(this);
            }
            if (this.connection != null) {
                this.connection.freeChannel(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.G = true;
            this.connection.sendChannelEOF(this);
        }
    }

    public boolean isLocalEOF() {
        return this.G;
    }

    public boolean isRemoteEOF() {
        return this.F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.F = true;
            this.onChannelEOF();
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelEOF(this);
            }
        }
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.B.add(channelEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ConnectionProtocol connectionProtocol, long l2, long l3, long l4, long l5) throws IOException {
        this.localChannelId = l2;
        this.remoteChannelId = l3;
        this.remotePacketSize = l5;
        this.remoteWindow.increaseWindowSpace(l4);
        this.connection = connectionProtocol;
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
            this.onChannelOpen();
            Iterator iterator = this.B.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelOpen(this);
            }
        }
    }

    protected void init(ConnectionProtocol connectionProtocol, long l2, long l3, long l4, long l5, ChannelEventListener channelEventListener) throws IOException {
        if (channelEventListener != null) {
            this.addEventListener(channelEventListener);
        }
        this.init(connectionProtocol, l2, l3, l4, l5);
    }

    protected abstract void onChannelClose() throws IOException;

    protected abstract void onChannelEOF() throws IOException;

    protected abstract void onChannelOpen() throws IOException;

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3) throws IOException;

    public void setName(String string) {
        this.C = string;
    }

    public String getName() {
        return this.C;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

