/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.ScpClient;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.SshEventAdapter;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelEventAdapter;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelFactory;
import com.enterprisedt.net.j2ssh.connection.ConnectionProtocol;
import com.enterprisedt.net.j2ssh.net.TransportProvider;
import com.enterprisedt.net.j2ssh.net.TransportProviderFactory;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient;
import com.enterprisedt.net.j2ssh.sftp.SftpTransportProtocolEventHandler;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolClient;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolState;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.puretls.LoadProviders;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SshClient {
    protected AuthenticationProtocolClient authentication;
    protected ConnectionProtocol connection;
    protected TransportProtocolClient transport;
    protected int authenticationState = 1;
    protected int socketTimeout = 0;
    protected SshEventAdapter eventHandler = null;
    protected Vector activeChannels = new Vector();
    protected _A activeChannelListener = new _A();
    private Vector A = new Vector();

    public SshClient() {
        LoadProviders.init();
    }

    public String getAuthenticationBanner(int n2) throws IOException {
        if (this.authentication == null) {
            return "";
        }
        return this.authentication.getBannerMessage(n2);
    }

    public List getAvailableAuthMethods(String string) throws IOException {
        if (this.authentication != null) {
            return this.authentication.getAvailableAuths(string, this.connection.getServiceName());
        }
        return null;
    }

    public boolean isConnected() {
        TransportProtocolState transportProtocolState = this.transport == null ? null : this.transport.getState();
        int n2 = transportProtocolState == null ? 5 : transportProtocolState.getValue();
        return n2 == 4 || n2 == 3;
    }

    public boolean isAuthenticated() {
        return this.authenticationState == 4;
    }

    public String getServerId() {
        return this.transport.getRemoteId();
    }

    public SshPublicKey getServerHostKey() {
        return this.transport.getServerHostKey();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public int getRemoteEOL() {
        return this.transport.getRemoteEOL();
    }

    public void addEventHandler(SshEventAdapter sshEventAdapter) {
        if (this.transport != null) {
            this.transport.addEventHandler(sshEventAdapter);
            this.authentication.addEventListener(sshEventAdapter);
        } else {
            this.eventHandler = sshEventAdapter;
        }
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n2) {
        this.socketTimeout = n2;
    }

    public String getRemoteEOLString() {
        return this.transport.getRemoteEOL() == 1 ? "\r\n" : "\n";
    }

    public SshConnectionProperties getConnectionProperties() {
        return this.transport.getProperties();
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient) throws IOException {
        this.authenticationState = this.authentication.authenticate(sshAuthenticationClient, this.connection);
        return this.authenticationState;
    }

    public boolean acceptsKey(String string, SshPublicKey sshPublicKey) throws IOException {
        if (this.authenticationState != 4) {
            PublicKeyAuthenticationClient publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
            return publicKeyAuthenticationClient.acceptsKey(this.authentication, string, this.connection.getServiceName(), sshPublicKey);
        }
        throw new SshException("Authentication has been completed!");
    }

    public void connect(String string, HostKeyVerification hostKeyVerification) throws IOException {
        this.connect(string, 22, hostKeyVerification);
    }

    public void connect(String string, int n2, HostKeyVerification hostKeyVerification) throws IOException {
        SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
        sshConnectionProperties.setHost(string);
        sshConnectionProperties.setPort(n2);
        this.connect(sshConnectionProperties, hostKeyVerification);
    }

    public void connect(SshConnectionProperties sshConnectionProperties, HostKeyVerification hostKeyVerification) throws UnknownHostException, IOException {
        TransportProvider transportProvider = TransportProviderFactory.connectTransportProvider(sshConnectionProperties, this.socketTimeout);
        this.transport = new TransportProtocolClient(hostKeyVerification, sshConnectionProperties);
        this.transport.addEventHandler(this.eventHandler);
        this.transport.startTransportProtocol(transportProvider);
        this.authentication = new AuthenticationProtocolClient();
        this.authentication.addEventListener(this.eventHandler);
        this.transport.requestService(this.authentication);
        this.connection = new ConnectionProtocol();
    }

    public void setKexTimeout(long l2) throws IOException {
        this.transport.setKexTimeout(l2);
    }

    public void setKexTransferLimit(long l2) throws IOException {
        this.transport.setKexTransferLimit(l2);
    }

    public void setSendIgnore(boolean bl) {
        this.transport.setSendIgnore(bl);
    }

    public void disconnect() {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnect("Terminating connection");
        }
    }

    public long getOutgoingByteCount() {
        return this.transport.getOutgoingByteCount();
    }

    public long getIncomingByteCount() {
        return this.transport.getIncomingByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveChannelCount() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return this.activeChannels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveChannels() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return (List)this.activeChannels.clone();
        }
    }

    public boolean hasActiveSession(String string) {
        Iterator iterator = this.activeChannels.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SessionChannelClient) || !((SessionChannelClient)e2).getSessionType().equals(string)) continue;
            return true;
        }
        return false;
    }

    public SessionChannelClient getActiveSession(String string) throws IOException {
        Iterator iterator = this.activeChannels.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SessionChannelClient) || !((SessionChannelClient)e2).getSessionType().equals(string)) continue;
            return (SessionChannelClient)e2;
        }
        throw new IOException("There are no active " + string + " sessions");
    }

    public boolean isActiveChannel(Channel channel) {
        return this.activeChannels.contains(channel);
    }

    public SessionChannelClient openSessionChannel() throws IOException {
        return this.openSessionChannel(null);
    }

    public SessionChannelClient openSessionChannel(ChannelEventListener channelEventListener) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        SessionChannelClient sessionChannelClient = new SessionChannelClient();
        sessionChannelClient.addEventListener(this.activeChannelListener);
        if (!this.connection.openChannel(sessionChannelClient, channelEventListener)) {
            throw new SshException("The server refused to open a session");
        }
        return sessionChannelClient;
    }

    public SftpClient openSftpClient() throws IOException, FTPException {
        return this.openSftpClient(0, null);
    }

    public SftpClient openSftpClient(int n2) throws IOException, FTPException {
        return this.openSftpClient(n2, null);
    }

    public SftpClient openSftpClient(int n2, ChannelEventListener channelEventListener) throws IOException, FTPException {
        SftpClient sftpClient = new SftpClient(this, n2, channelEventListener);
        this.A.add(sftpClient);
        SftpTransportProtocolEventHandler sftpTransportProtocolEventHandler = new SftpTransportProtocolEventHandler(sftpClient.A());
        this.transport.addEventHandler(sftpTransportProtocolEventHandler);
        return sftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveSftpClient() {
        Vector vector = this.A;
        synchronized (vector) {
            return this.A.size() > 0;
        }
    }

    public SftpClient getActiveSftpClient() throws IOException {
        Vector vector = this.A;
        synchronized (vector) {
            if (this.A.size() > 0) {
                return (SftpClient)this.A.get(0);
            }
            throw new SshException("There are no active SFTP clients");
        }
    }

    public ScpClient openScpClient() throws IOException {
        return new ScpClient(new File(System.getProperty("user.home")), this, false, this.activeChannelListener);
    }

    public ScpClient openScpClient(File file) throws IOException {
        return new ScpClient(file, this, false, this.activeChannelListener);
    }

    public SftpSubsystemClient openSftpChannel() throws IOException {
        return this.openSftpChannel(null);
    }

    public SftpSubsystemClient openSftpChannel(ChannelEventListener channelEventListener) throws IOException {
        SftpSubsystemClient sftpSubsystemClient = new SftpSubsystemClient();
        if (!this.openChannel(sftpSubsystemClient)) {
            throw new SshException("The SFTP subsystem failed to start");
        }
        if (!sftpSubsystemClient.initialize()) {
            throw new SshException("The SFTP Subsystem could not be initialized");
        }
        return sftpSubsystemClient;
    }

    public boolean openChannel(Channel channel) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        return this.connection.openChannel(channel, this.activeChannelListener);
    }

    public void allowChannelOpen(String string, ChannelFactory channelFactory) throws IOException {
        this.connection.addChannelFactory(string, channelFactory);
    }

    public void denyChannelOpen(String string) throws IOException {
        this.connection.removeChannelFactory(string);
    }

    public byte[] sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        return this.connection.sendGlobalRequest(string, bl, byArray);
    }

    class _A
    extends ChannelEventAdapter {
        _A() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelOpen(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.add(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelClose(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.remove(channel);
            }
        }
    }
}

