/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh;

import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ScpClient {
    private SshClient D;
    private File C;
    private boolean A;
    private ChannelEventListener B;

    public ScpClient(SshClient sshClient, boolean bl, ChannelEventListener channelEventListener) {
        this(new File(ConfigurationLoader.checkAndGetProperty("user.dir", ".")), sshClient, bl, channelEventListener);
    }

    public ScpClient(File file, SshClient sshClient, boolean bl, ChannelEventListener channelEventListener) {
        this.D = sshClient;
        this.C = file;
        this.A = bl;
        this.B = channelEventListener;
    }

    public void put(InputStream inputStream, long l2, String string, String string2) throws IOException {
        _A _A2 = new _A("scp -t " + (this.A ? "-v " : "") + string2);
        _A2.addEventListener(this.B);
        if (!this.D.openChannel(_A2)) {
            throw new IOException("Failed to open SCP channel");
        }
        _A2.C();
        _A2.A(inputStream, l2, string);
        _A2.close();
    }

    public InputStream get(String string) throws IOException {
        _A _A2 = new _A("scp -f " + (this.A ? "-v " : "") + string);
        _A2.addEventListener(this.B);
        if (!this.D.openChannel(_A2)) {
            throw new IOException("Failed to open SCP Channel");
        }
        return _A2.E();
    }

    public void put(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.C, string);
        }
        if (!file.exists()) {
            throw new IOException(string + " does not exist");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(string + " is not a regular file or directory");
        }
        if (file.isDirectory() && !bl) {
            throw new IOException(string + " is a directory, use recursive mode");
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        _A _A2 = new _A("scp " + (file.isDirectory() ? "-d " : "") + "-t " + (bl ? "-r " : "") + (this.A ? "-v " : "") + string2);
        _A2.addEventListener(this.B);
        if (!this.D.openChannel(_A2)) {
            throw new IOException("Failed to open SCP channel");
        }
        _A2.C();
        _A2.A(file, bl);
        _A2.close();
    }

    public void put(String[] stringArray, String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (stringArray.length == 1) {
            this.put(stringArray[0], string, bl);
        } else {
            _A _A2 = new _A("scp -d -t " + (bl ? "-r " : "") + (this.A ? "-v " : "") + string);
            _A2.addEventListener(this.B);
            if (!this.D.openChannel(_A2)) {
                throw new IOException("Failed to open SCP channel");
            }
            _A2.C();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file = new File(stringArray[i2]);
                if (!file.isAbsolute()) {
                    file = new File(this.C, stringArray[i2]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    throw new IOException(file.getName() + " is not a regular file or directory");
                }
                _A2.A(file, bl);
            }
            _A2.close();
        }
    }

    public void get(String string, String[] stringArray, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append("\" ");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        this.get(string, string2, bl);
    }

    public void get(String string, String string2, boolean bl) throws IOException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.C, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException(string + " is not a regular file or directory");
        }
        _A _A2 = new _A("scp -f " + (bl ? "-r " : "") + (this.A ? "-v " : "") + string2);
        _A2.addEventListener(this.B);
        if (!this.D.openChannel(_A2)) {
            throw new IOException("Failed to open SCP Channel");
        }
        _A2.A(file);
        _A2.close();
    }

    class _B
    extends InputStream {
        long D;
        InputStream A;
        long C;
        _A B;

        _B(long l2, InputStream inputStream, _A _A2) {
            this.D = l2;
            this.A = inputStream;
            this.B = _A2;
        }

        public int read() throws IOException {
            if (this.C == this.D) {
                return -1;
            }
            if (this.C >= this.D) {
                throw new EOFException("End of file.");
            }
            int n2 = this.A.read();
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.C;
            if (this.C == this.D) {
                this.B.C();
                this.B.D();
            }
            return n2;
        }

        public void close() throws IOException {
            this.B.close();
        }
    }

    class _A
    extends SessionChannelClient {
        byte[] R = new byte[16384];
        String S;

        _A(String string) {
            this.S = string;
            this.setName("scp");
        }

        protected void onChannelOpen() throws IOException {
            if (!this.executeCommand(this.S)) {
                throw new IOException("Failed to execute the command " + this.S);
            }
        }

        private boolean B(File file, boolean bl) throws IOException {
            if (!bl) {
                this.A("File " + file.getName() + " is a directory, use recursive mode");
                return false;
            }
            String string = "D0755 0 " + file.getName() + "\n";
            this.out.write(string.getBytes());
            this.C();
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file2 = new File(file, stringArray[i2]);
                this.A(file2, bl);
            }
            this.out.write("E\n".getBytes());
            return true;
        }

        private void A(InputStream inputStream, long l2, String string) throws IOException {
            String string2 = "C0644 " + l2 + " " + string + "\n";
            this.out.write(string2.getBytes());
            this.C();
            this.A(inputStream, l2);
            this.D();
            this.C();
        }

        private void A(File file, boolean bl) throws IOException {
            if (file.isDirectory()) {
                if (!this.B(file, bl)) {
                    return;
                }
            } else if (file.isFile()) {
                String string = "C0644 " + file.length() + " " + file.getName() + "\n";
                this.out.write(string.getBytes());
                this.C();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.A(fileInputStream, file.length());
                this.D();
            } else {
                throw new IOException(file.getName() + " not valid for SCP");
            }
            this.C();
        }

        private void A(File file) throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.D();
            block7: while (true) {
                try {
                    string = this.B();
                }
                catch (EOFException eOFException) {
                    return;
                }
                char c2 = string.charAt(0);
                switch (c2) {
                    case 'E': {
                        this.D();
                        return;
                    }
                    case 'T': {
                        throw new IOException("SCP time not supported: " + string);
                    }
                    case 'C': 
                    case 'D': {
                        Object object;
                        String string2 = file.getAbsolutePath();
                        this.A(string, stringArray);
                        if (file.isDirectory()) {
                            string2 = string2 + File.separator + stringArray[2];
                        }
                        File file2 = new File(string2);
                        if (c2 == 'D') {
                            if (file2.exists()) {
                                if (!file2.isDirectory()) {
                                    object = "Invalid target " + file2.getName() + ", must be a directory";
                                    this.A((String)object);
                                    throw new IOException((String)object);
                                }
                            } else if (!file2.mkdir()) {
                                object = "Could not create directory: " + file2.getName();
                                this.A((String)object);
                                throw new IOException((String)object);
                            }
                            this.A(file2);
                            continue block7;
                        }
                        object = new FileOutputStream(file2);
                        this.D();
                        long l2 = Long.parseLong(stringArray[1]);
                        this.A((FileOutputStream)object, l2);
                        this.C();
                        this.D();
                        continue block7;
                    }
                }
                break;
            }
            this.A("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private InputStream E() throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.D();
            try {
                string = this.B();
            }
            catch (EOFException eOFException) {
                return null;
            }
            char c2 = string.charAt(0);
            switch (c2) {
                case 'E': {
                    this.D();
                    return null;
                }
                case 'T': {
                    throw new IOException("SCP time not supported: " + string);
                }
                case 'D': {
                    throw new IOException("Directories cannot be copied to a stream");
                }
                case 'C': {
                    this.A(string, stringArray);
                    this.D();
                    long l2 = Long.parseLong(stringArray[1]);
                    return new BufferedInputStream(new _B(l2, this.in, this), 16384);
                }
            }
            this.A("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private void A(String string, String[] stringArray) throws IOException {
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(32, n2 + 1);
            if (n2 == -1 || n3 == -1) {
                this.A("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n2);
            stringArray[1] = string.substring(n2 + 1, n3);
            stringArray[2] = string.substring(n3 + 1);
        }

        private String B() throws IOException {
            int n2;
            int n3 = 0;
            while ((n2 = this.in.read()) != 10 && n2 >= 0) {
                this.R[n3++] = (byte)n2;
            }
            if (n2 == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            if (this.R[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.R[0] == 2 || this.R[0] == 1) {
                String string = new String(this.R, 1, n3 - 1);
                if (this.R[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: " + string);
            }
            return new String(this.R, 0, n3);
        }

        private void C() throws IOException {
            int n2 = this.in.read();
            if (n2 == 0) {
                return;
            }
            if (n2 == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.B();
            if (n2 == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }

        private void D() throws IOException {
            this.out.write(0);
        }

        private void A(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void A(InputStream inputStream, long l2) throws IOException {
            int n2 = 0;
            try {
                while ((long)n2 < l2) {
                    int n3 = inputStream.read(this.R, 0, (int)(l2 - (long)n2 < (long)this.R.length ? l2 - (long)n2 : (long)this.R.length));
                    if (n3 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n2 += n3;
                    this.out.write(this.R, 0, n3);
                }
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void A(FileOutputStream fileOutputStream, long l2) throws IOException {
            int n2 = 0;
            try {
                while ((long)n2 < l2) {
                    int n3 = this.in.read(this.R, 0, (int)(l2 - (long)n2 < (long)this.R.length ? l2 - (long)n2 : (long)this.R.length));
                    if (n3 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n2 += n3;
                    fileOutputStream.write(this.R, 0, n3);
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

