/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssl.B;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore;
import com.enterprisedt.net.ftp.ssl.SSLFTPCipherSuite;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.ftp.ssl.SSLFTPStandardValidator;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import com.enterprisedt.net.puretls.SSLContext;
import com.enterprisedt.net.puretls.SSLException;
import com.enterprisedt.net.puretls.SSLPeerCertVerifier;
import com.enterprisedt.net.puretls.SSLPrematureCloseException;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.LicenseProperties;
import java.io.BufferedInputStream;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.ParseException;
import java.util.Vector;

public class SSLFTPClient
extends FTPClient
implements ProFTPClientInterface {
    public static final String AUTH_TLS = "TLS";
    public static final String AUTH_TLS_C = "TLS-C";
    public static final String AUTH_SSL = "SSL";
    public static final char PROT_CLEAR = 'C';
    public static final char PROT_PRIVATE = 'P';
    private static final int n = -1;
    private SSLContext h;
    private SSLFTPCertificateStore p;
    private int k = 0;
    private boolean o = false;
    private static Logger j = Logger.getLogger(class$com$enterprisedt$net$ftp$ssl$SSLFTPClient == null ? (class$com$enterprisedt$net$ftp$ssl$SSLFTPClient = SSLFTPClient.class$("com.enterprisedt.net.ftp.ssl.SSLFTPClient")) : class$com$enterprisedt$net$ftp$ssl$SSLFTPClient);
    private static LicenseProperties m = new LicenseProperties();
    private SSLFTPValidator g;
    private RecursiveOperations l = new RecursiveOperations();
    private boolean i = true;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$ssl$SSLFTPClient;

    public SSLFTPClient() throws FTPException {
        m.checkLicence();
        this.h = new SSLContext();
        this.setRemotePort(-1);
        this.setCustomValidator(new SSLFTPStandardValidator());
        this.D();
    }

    public SSLFTPClient(String string, int n2) throws UnknownHostException {
        this(string, -1, 0, n2);
    }

    public SSLFTPClient(String string, int n2, int n3) throws UnknownHostException {
        this(string, n2, 0, n3);
    }

    public SSLFTPClient(String string, int n2, int n3, int n4) throws UnknownHostException {
        this(InetAddress.getByName(string), n2, n3, n4);
    }

    public SSLFTPClient(InetAddress inetAddress, int n2) {
        this(inetAddress, -1, 0, n2);
    }

    public SSLFTPClient(InetAddress inetAddress, int n2, int n3) {
        this(inetAddress, n2, 0, n3);
    }

    public SSLFTPClient(InetAddress inetAddress, int n2, int n3, int n4) {
        m.checkLicence();
        this.h = new SSLContext();
        try {
            this.setCustomValidator(new SSLFTPStandardValidator());
            this.D();
            this.setRemotePort(n2);
            this.setRemoteAddr(inetAddress);
            this.setTimeout(n3);
            this.setConfigFlags(n4);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            j.error(string);
            throw new RuntimeException(string);
        }
        catch (FTPException fTPException) {
            String string = fTPException.getMessage();
            j.error(string);
            throw new RuntimeException(string);
        }
    }

    private void D() {
        this.p = new SSLFTPCertificateStore();
        this.p.A(new SSLFTPCertificateStore._A(){

            public void A(SSLFTPCertificateStore sSLFTPCertificateStore) {
                SSLFTPClient.this.h.setRootCertificates(sSLFTPCertificateStore.B());
            }
        });
    }

    public void setConfigFlags(int n2) throws FTPException {
        this.checkConnection(false);
        this.k = n2;
        if ((n2 & 0x20) != 0) {
            this.o = true;
        }
    }

    public int getConfigFlags() {
        return this.k;
    }

    public void connect() throws IOException, FTPException, SSLFTPCertificateException {
        this.checkConnection(false);
        if (this.remoteHost == null) {
            throw new FTPException("No host-name has been set.  Please use setRemoteHost()");
        }
        if (this.getRemotePort() < 0) {
            this.setRemotePort(!this.o ? 21 : 990);
        }
        this.h.getPolicy().handshakeOnConnect(this.o);
        this.h.getPolicy().waitOnClose(false);
        j.debug("Created " + (this.o ? "implicit" : "explicit") + " FTPS client.");
        j.debug("Connecting to " + this.getRemoteAddr() + ":" + this.getRemotePort());
        try {
            B b2 = new B(this.h, this.getRemoteAddr(), this.getRemotePort(), this.getTimeout(), this.o, this.k, this.g, this.messageListener);
            this.initialize(b2);
        }
        catch (SSLException sSLException) {
            j.debug("Caught: " + sSLException.getClass().getName());
            Throwable throwable = sSLException;
            while (throwable != null) {
                if (throwable instanceof CertificateVerifyException) {
                    j.debug("Rethrowing as SSLFTPCertificateException");
                    CertificateVerifyException certificateVerifyException = (CertificateVerifyException)throwable;
                    throw new SSLFTPCertificateException(certificateVerifyException.getMessage(), certificateVerifyException.getCertificates());
                }
                if (!(throwable instanceof SSLException)) break;
                if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                j.debug("Inner throwable = " + throwable.getClass().getName());
            }
            j.debug("Caught: " + sSLException.getClass().getName());
            throw sSLException;
        }
    }

    protected int readChar(LineNumberReader lineNumberReader) throws IOException {
        try {
            return lineNumberReader.read();
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return -1;
        }
    }

    protected String readLine(LineNumberReader lineNumberReader) throws IOException {
        try {
            return lineNumberReader.readLine();
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return null;
        }
    }

    protected int readChunk(BufferedInputStream bufferedInputStream, byte[] byArray, int n2) throws IOException {
        try {
            return bufferedInputStream.read(byArray, 0, n2);
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return -1;
        }
    }

    public Vector getCertificateChain() {
        return ((B)this.control).E();
    }

    public boolean getValidateServer() {
        return !this.h.getPolicy().acceptUnverifiableCertificatesP();
    }

    public void setValidateServer(boolean bl) throws FTPException {
        this.checkConnection(false);
        j.debug("Turned server validation " + (bl ? "on" : "off"));
        this.h.getPolicy().acceptUnverifiableCertificates(!bl);
    }

    public void setCustomValidator(SSLFTPValidator sSLFTPValidator) throws FTPException {
        this.checkConnection(false);
        j.debug("Setting custom validator to " + sSLFTPValidator.getClass().getName());
        this.g = sSLFTPValidator;
        if (this.g instanceof SSLFTPStandardValidator) {
            ((SSLFTPStandardValidator)this.g).A(this.p);
        }
        SSLPeerCertVerifier sSLPeerCertVerifier = new SSLPeerCertVerifier(){

            public boolean acceptPeerCertificate(Vector vector, boolean bl) {
                try {
                    return SSLFTPClient.this.g.validateServerCertificate(bl, SSLFTPClient.this.A(vector), SSLFTPClient.this.getRemoteHost());
                }
                catch (SSLFTPException sSLFTPException) {
                    j.error("Error while verifying server certificate", sSLFTPException);
                    return false;
                }
            }
        };
        this.h.setVerifier(sSLPeerCertVerifier);
    }

    private Vector A(Vector vector) throws SSLFTPCertificateException {
        Vector<SSLFTPCertificate> vector2 = new Vector<SSLFTPCertificate>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            X509Cert x509Cert = (X509Cert)vector.elementAt(i2);
            vector2.add(new SSLFTPCertificate(x509Cert));
        }
        return vector2;
    }

    public SSLFTPCipherSuite[] getEnabledCipherSuites() {
        short[] sArray = this.h.getPolicy().getCipherSuites();
        SSLFTPCipherSuite[] sSLFTPCipherSuiteArray = new SSLFTPCipherSuite[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sSLFTPCipherSuiteArray[i2] = SSLFTPCipherSuite.getCipherSuite(sArray[i2]);
        }
        return sSLFTPCipherSuiteArray;
    }

    public void disableAllCipherSuites() throws FTPException {
        this.checkConnection(false);
        j.debug("Disabled all cipher-suites");
        this.h.getPolicy().setCipherSuites(new short[0]);
    }

    public void enableCipherSuite(SSLFTPCipherSuite sSLFTPCipherSuite) throws FTPException {
        this.checkConnection(false);
        short[] sArray = this.h.getPolicy().getCipherSuites();
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] != sSLFTPCipherSuite.getCode()) continue;
            return;
        }
        short[] sArray2 = new short[sArray.length + 1];
        for (int i3 = 0; i3 < sArray.length; ++i3) {
            sArray2[i3] = sArray[i3];
        }
        sArray2[sArray.length] = sSLFTPCipherSuite.getCode();
        this.h.getPolicy().setCipherSuites(sArray2);
        j.debug("Enabled cipher-suite " + sSLFTPCipherSuite.getName());
    }

    public void loadClientKeyFile(InputStream inputStream, String string) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.h.loadEAYKeyFile(inputStream, string);
        j.debug("Loaded client key from input-stream.");
    }

    public void loadClientKeyFile(String string, String string2) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.h.loadEAYKeyFile(string, string2);
        j.debug("Loaded client key file " + string);
    }

    public void loadClientCertificate(InputStream inputStream, String string) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.h.loadEAYKeyFile(inputStream, string);
        j.debug("Loaded client key from input-stream.");
    }

    public void loadClientCertificate(String string, String string2) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.h.loadEAYKeyFile(string, string2);
        j.debug("Loaded client key file " + string);
    }

    public void setClientCertificate(Certificate certificate, PrivateKey privateKey) throws SSLFTPCertificateException {
        try {
            if (certificate == null) {
                throw new NullPointerException("Certificate argument is null");
            }
            if (privateKey == null) {
                throw new NullPointerException("Private key argument is null");
            }
            this.h.setClientCertPrivKey(new Certificate[]{certificate}, privateKey);
        }
        catch (Exception exception) {
            throw new SSLFTPCertificateException(exception.getMessage());
        }
    }

    public void loadRootCertificates(InputStream inputStream) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.p.importPEMFile(inputStream);
        j.debug("Loaded root certificates from InputStream");
    }

    public void loadRootCertificates(String string) throws IOException, FTPException {
        this.checkConnection(false);
        this.p.importPEMFile(string);
        j.debug("Loaded root certificates from " + string);
    }

    public SSLFTPCertificateStore getRootCertificateStore() {
        return this.p;
    }

    public void auth(String string) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            if (this.o) {
                throw new SSLFTPException("The AUTH command cannot be used with implicit FTPS.");
            }
            if (!(string.equals(AUTH_TLS) || string.equals(AUTH_TLS_C) || string.equals(AUTH_SSL))) {
                throw new FTPException("Only TLS, TLS-C, and SSL are valid arguments for the AUTH command.");
            }
            FTPReply fTPReply = this.control.sendCommand("AUTH " + string);
            String[] stringArray = new String[]{"234", "334", "200"};
            this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
            B b2 = (B)this.control;
            b2.F();
            if ((this.k & 0x10) == 0) {
                this.pbsz(0);
                this.prot('P');
            }
        }
        catch (SSLFTPCertificateException sSLFTPCertificateException) {
            try {
                j.debug("Forcing disconnect");
                this.quit();
            }
            catch (Throwable throwable) {
                j.debug("Expected error during disconnect: " + throwable.getMessage());
            }
            throw sSLFTPCertificateException;
        }
    }

    public void ccc() throws FTPException, IOException {
        this.checkConnection(true);
        B b2 = (B)this.control;
        if (!b2.G()) {
            throw new FTPException("Must issue \"AUTH\" command before issuing \"CCC\" command.");
        }
        if (this.o) {
            j.warn("\"CCC\" should only be used with explicit FTPS.");
        }
        FTPReply fTPReply = this.control.sendCommand("CCC");
        String[] stringArray = new String[]{"200"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        b2.H();
    }

    public void auth(char c2) throws IOException, FTPException {
        this.checkConnection(true);
        if (!this.o) {
            throw new SSLFTPException("This version of auth() can be used with implicit FTPS only.");
        }
        this.pbsz(0);
        this.prot(c2);
    }

    public void prot(char c2) throws IOException, FTPException {
        this.checkConnection(true);
        B b2 = (B)this.control;
        if (!b2.G()) {
            throw new FTPException("Must issue \"AUTH\" command or use implicit SSL before issuing \"PROT\" command.");
        }
        switch (c2) {
            case 'C': 
            case 'P': {
                FTPReply fTPReply = this.control.sendCommand("PROT " + c2);
                String[] stringArray = new String[]{"200"};
                this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
                b2.B(c2 == 'P');
                break;
            }
            default: {
                throw new FTPException("Only 'C' and 'P' are valid arguments for the PROT command.");
            }
        }
    }

    public void pbsz(int n2) throws IOException, FTPException {
        this.checkConnection(true);
        B b2 = (B)this.control;
        if (!b2.G()) {
            throw new FTPException("Must issue \"AUTH\" command or use implicit SSL before issuing \"PBSZ\" command.");
        }
        if (n2 != 0) {
            throw new FTPException("The buffer-size defined by the PBSZ command must be 0.");
        }
        FTPReply fTPReply = this.control.sendCommand("PBSZ " + n2);
        String[] stringArray = new String[]{"200"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void mdelete(String string) throws IOException, FTPException, ParseException {
        this.l.deleteFilesCurrentDir(this, new WildcardFilter(string));
    }

    public void mdelete(FileFilter fileFilter) throws IOException, FTPException, ParseException {
        this.l.deleteFilesCurrentDir(this, fileFilter);
    }

    public void mdelete(String string, String string2, boolean bl) throws IOException, FTPException, ParseException {
        this.l.deleteFiles(this, string, new WildcardFilter(string2), bl);
    }

    public void mdelete(String string, FileFilter fileFilter, boolean bl) throws IOException, FTPException, ParseException {
        this.l.deleteFiles(this, string, fileFilter, bl);
    }

    public void rmdir(String string, boolean bl) throws IOException, FTPException, ParseException {
        if (!bl) {
            this.rmdir(string);
        } else {
            this.l.delete(this, string);
        }
    }

    public void mput(String string, String string2) throws IOException, FTPException {
        this.l.putFilesIntoCurrentDir(this, string, new WildcardFilter(string2));
    }

    public void mput(String string, FileFilter fileFilter) throws IOException, FTPException {
        this.l.putFilesIntoCurrentDir(this, string, fileFilter);
    }

    public void mput(String string, String string2, String string3, boolean bl) throws FTPException, IOException {
        this.l.put(this, string, string2, new WildcardFilter(string3), bl);
    }

    public void mput(String string, String string2, FileFilter fileFilter, boolean bl) throws FTPException, IOException {
        this.l.put(this, string, string2, fileFilter, bl);
    }

    public void mget(String string, String string2) throws IOException, FTPException, ParseException {
        this.l.getFilesFromCurrentDir(this, string, new WildcardFilter(string2));
    }

    public void mget(String string, FileFilter fileFilter) throws IOException, FTPException, ParseException {
        this.l.getFilesFromCurrentDir(this, string, fileFilter);
    }

    public void mget(String string, String string2, String string3, boolean bl) throws FTPException, IOException, ParseException {
        this.l.get(this, string, string2, new WildcardFilter(string3), bl);
    }

    public void mget(String string, String string2, FileFilter fileFilter, boolean bl) throws FTPException, IOException, ParseException {
        this.l.get(this, string, string2, fileFilter, bl);
    }

    public void setDetectTransferMode(boolean bl) {
        this.i = bl;
    }

    public boolean getDetectTransferMode() {
        return this.i;
    }

    public int getCountBeforeSleep() {
        return this.l.getCountBeforeSleep();
    }

    public void setCountBeforeSleep(int n2) {
        this.l.setCountBeforeSleep(n2);
    }

    public boolean isSleepEnabled() {
        return this.l.isSleepEnabled();
    }

    public void setSleepEnabled(boolean bl) {
        this.l.setSleepEnabled(bl);
    }

    public int getSleepTime() {
        return this.l.getSleepTime();
    }

    public void setSleepTime(int n2) {
        this.l.setSleepTime(n2);
    }

    public static SSLFTPCertificate getServerCertificate(String string) throws FTPException, IOException {
        return SSLFTPClient.getServerCertificate(string, 21);
    }

    public static SSLFTPCertificate getServerCertificate(String string, int n2) throws FTPException, IOException {
        SSLFTPClient sSLFTPClient = new SSLFTPClient();
        try {
            sSLFTPClient.setRemoteHost(string);
            sSLFTPClient.setRemotePort(n2);
            sSLFTPClient.setValidateServer(true);
            sSLFTPClient.connect();
            sSLFTPClient.auth(AUTH_TLS);
            sSLFTPClient.quit();
            return null;
        }
        catch (SSLFTPCertificateException sSLFTPCertificateException) {
            Vector vector = sSLFTPCertificateException.getCertificates();
            return vector != null ? (vector.size() > 0 ? (SSLFTPCertificate)vector.lastElement() : null) : null;
        }
    }

    public static String getServerSecurityMechanism(String string) throws FTPException, IOException {
        return SSLFTPClient.getServerSecurityMechanism(string, 21);
    }

    public static String getServerSecurityMechanism(String string, int n2) throws FTPException, IOException {
        SSLFTPClient sSLFTPClient = new SSLFTPClient();
        sSLFTPClient.setRemoteHost(string);
        sSLFTPClient.setRemotePort(n2);
        sSLFTPClient.connect();
        String[] stringArray = new String[]{AUTH_TLS, AUTH_SSL};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            FTPReply fTPReply = sSLFTPClient.control.sendCommand("AUTH " + stringArray[i2]);
            if (!fTPReply.getReplyCode().equals("234") && !fTPReply.getReplyCode().equals("334") && !fTPReply.getReplyCode().equals("200")) continue;
            sSLFTPClient.control.logout();
            return stringArray[i2];
        }
        sSLFTPClient.control.logout();
        return null;
    }

    public boolean isImplicitFTPS() {
        return this.o;
    }

    public void setImplicitFTPS(boolean bl) {
        this.o = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        j.info("edtFTPj - PRO version");
    }

    public static class ConfigFlags {
        public static final int DISABLE_CONTROL_SSL_CLOSURE = 1;
        public static final int DISABLE_DATA_SSL_CLOSURE = 2;
        public static final int DISABLE_SSL_CLOSURE = 3;
        public static final int DISABLE_CONTROL_WAIT_ON_CLOSE = 4;
        public static final int DISABLE_DATA_WAIT_ON_CLOSE = 8;
        public static final int DISABLE_WAIT_ON_CLOSE = 12;
        public static final int START_WITH_CLEAR_DATA_CHANNELS = 16;
        public static final int IMPLICIT_FTPS = 32;
        public static final int ALLOW_BASIC_CONSTRAINTS_IN_NON_CA = 64;
        public static final int DISABLE_SESSION_RESUMPTION = 128;
    }
}

