/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.net.puretls.cert.X509Cert;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class SSLFTPCertificate {
    private X509Cert A;
    private byte[] E;
    private BigInteger D;
    private DistinguishedName B;
    private DistinguishedName H;
    private Date G;
    private Date C;
    private Vector F;

    SSLFTPCertificate(X509Cert x509Cert) throws SSLFTPCertificateException {
        this.A(x509Cert);
    }

    public SSLFTPCertificate(Certificate certificate) throws SSLFTPCertificateException {
        try {
            this.A(new X509Cert(certificate.getEncoded()));
        }
        catch (Exception exception) {
            throw new SSLFTPCertificateException(exception.getMessage());
        }
    }

    private void A(X509Cert x509Cert) throws SSLFTPCertificateException {
        this.A = x509Cert;
        this.E = x509Cert.getDER();
        this.D = x509Cert.getSerial();
        if (x509Cert.getSubjectName() != null) {
            try {
                this.B = new DistinguishedName(x509Cert.getSubjectName());
            }
            catch (SSLFTPException sSLFTPException) {
                throw new SSLFTPCertificateException("Certificate has invalid subject name: " + sSLFTPException.getMessage());
            }
        }
        if (x509Cert.getIssuerName() != null) {
            try {
                this.H = new DistinguishedName(x509Cert.getIssuerName());
            }
            catch (SSLFTPException sSLFTPException) {
                throw new SSLFTPCertificateException("Certificate has invalid issuer name: " + sSLFTPException.getMessage());
            }
        }
        this.G = x509Cert.getValidityNotBefore();
        this.C = x509Cert.getValidityNotAfter();
        this.F = new Vector();
        if (x509Cert.getExtensions() != null) {
            for (int i2 = 0; i2 < x509Cert.getExtensions().size(); ++i2) {
                com.enterprisedt.net.puretls.sslg.Extension extension = (com.enterprisedt.net.puretls.sslg.Extension)x509Cert.getExtensions().elementAt(i2);
                this.F.add(new Extension(extension));
            }
        }
    }

    X509Cert A() {
        return this.A;
    }

    public byte[] getCertDER() {
        return this.E;
    }

    public Vector getExtensions() {
        return this.F;
    }

    public DistinguishedName getIssuerName() {
        return this.H;
    }

    public BigInteger getSerial() {
        return this.D;
    }

    public DistinguishedName getSubjectName() {
        return this.B;
    }

    public Date getValidityNotAfter() {
        return this.C;
    }

    public Date getValidityNotBefore() {
        return this.G;
    }

    public void writePEM(OutputStream outputStream) throws IOException {
        this.writePEM(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public void writePEM(Writer writer) throws IOException {
        writer.write("-----BEGIN CERTIFICATE-----\n");
        writer.write(Base64.encodeBytes(this.E, false));
        writer.write("\n-----END CERTIFICATE-----\n");
        writer.flush();
    }

    private String A(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("=");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.B.getOrganisationName() + "\n");
            stringBuffer.append(this.A(this.B.getOrganisationName().length()) + "\n");
        } else if (this.B.getOrganisationName() != null) {
            stringBuffer.append("  Org Name = " + this.B.getOrganisationName() + "\n");
        }
        if (this.B.getOrganisationalUnit() != null) {
            stringBuffer.append("  Org Unit = " + this.B.getOrganisationalUnit() + "\n");
        }
        if (this.B.getCountry() != null) {
            stringBuffer.append("  Country  = " + this.B.getCountry() + "\n");
        }
        if (this.B.getState() != null) {
            stringBuffer.append("  State    = " + this.B.getState() + "\n");
        }
        if (this.B.getLocality() != null) {
            stringBuffer.append("  Locality = " + this.B.getLocality() + "\n");
        }
        if (this.B.getCommonName() != null) {
            stringBuffer.append("  CN       = " + this.B.getCommonName() + "\n");
        }
        if (this.getValidityNotBefore() != null) {
            stringBuffer.append("  Valid from  " + this.getValidityNotBefore().toString() + "\n");
        }
        if (this.getValidityNotAfter() != null) {
            stringBuffer.append("  Valid until " + this.getValidityNotAfter().toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SSLFTPCertificate)) {
            return false;
        }
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)object;
        if (this.E.length != sSLFTPCertificate.E.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.E.length; ++i2) {
            if (this.E[i2] == sSLFTPCertificate.E[i2]) continue;
            return false;
        }
        return true;
    }

    public static class Extension {
        private byte[] A;
        private boolean C;
        private byte[] B;

        private Extension(com.enterprisedt.net.puretls.sslg.Extension extension) {
            this.A = extension.getOID();
            this.C = extension.isCritical();
            this.B = extension.getValue();
        }

        public boolean isCritical() {
            return this.C;
        }

        public byte[] getOID() {
            return this.A;
        }

        public byte[] getValue() {
            return this.B;
        }
    }

    public static class DistinguishedName {
        private byte[] D;
        private String G;
        private String C;
        private String B;
        private String A;
        private String E;
        private String F;

        private DistinguishedName(com.enterprisedt.net.puretls.sslg.DistinguishedName distinguishedName) throws SSLFTPException {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i2 = 0; i2 < distinguishedName.getName().size(); ++i2) {
                Vector vector = (Vector)distinguishedName.getName().elementAt(i2);
                if (vector.size() != 1) {
                    throw new SSLFTPException("Multiple AVAs found in an RDN.");
                }
                String[] stringArray = (String[])vector.firstElement();
                if (stringArray.length != 2) {
                    throw new SSLFTPException("AVA array must contain 2 elements.");
                }
                hashtable.put(stringArray[0], stringArray[1]);
            }
            this.G = (String)hashtable.get("CN");
            this.C = (String)hashtable.get("O");
            this.B = (String)hashtable.get("OU");
            this.A = (String)hashtable.get("L");
            this.E = (String)hashtable.get("S");
            this.F = (String)hashtable.get("C");
        }

        public byte[] getDER() {
            return this.D;
        }

        public String getCountry() {
            return this.F;
        }

        public String getLocality() {
            return this.A;
        }

        public String getOrganisationalUnit() {
            return this.B;
        }

        public String getOrganisationName() {
            return this.C;
        }

        public String getState() {
            return this.E;
        }

        public String getCommonName() {
            return this.G;
        }
    }
}

