/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import java.util.ArrayList;
import java.util.Hashtable;

public class SSHFTPAlgorithm {
    public static final int CIPHER = 0;
    public static final int COMPRESSION = 1;
    public static final int KEY_EXCHANGE = 2;
    public static final int KEY_PAIR = 3;
    public static final int MAC = 4;
    public static final SSHFTPAlgorithm CIPHER_3DES_CBC;
    public static final SSHFTPAlgorithm CIPHER_BLOWFISH_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES128_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES192_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES256_CBC;
    public static final SSHFTPAlgorithm COMPRESSION_NONE;
    public static final SSHFTPAlgorithm KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1;
    public static final SSHFTPAlgorithm KEY_RSA;
    public static final SSHFTPAlgorithm KEY_DSA;
    public static final SSHFTPAlgorithm MAC_MD5_96;
    public static final SSHFTPAlgorithm MAC_MD5;
    public static final SSHFTPAlgorithm MAC_SHA1_96;
    public static final SSHFTPAlgorithm MAC_SHA1;
    private static Hashtable C;
    private String A;
    private int B;

    public static SSHFTPAlgorithm[] getAlgorithms() {
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = new SSHFTPAlgorithm[C.size()];
        C.values().toArray(sSHFTPAlgorithmArray);
        return sSHFTPAlgorithmArray;
    }

    public static SSHFTPAlgorithm[] getAlgorithms(int n2) throws SSHFTPException {
        if (n2 < 0 || n2 > 4) {
            throw new SSHFTPException("No such algorithm type " + n2);
        }
        ArrayList<SSHFTPAlgorithm> arrayList = new ArrayList<SSHFTPAlgorithm>();
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = C.values().iterator();
        while (sSHFTPAlgorithmArray.hasNext()) {
            SSHFTPAlgorithm sSHFTPAlgorithm = (SSHFTPAlgorithm)sSHFTPAlgorithmArray.next();
            if (sSHFTPAlgorithm.getType() != n2) continue;
            arrayList.add(sSHFTPAlgorithm);
        }
        sSHFTPAlgorithmArray = new SSHFTPAlgorithm[arrayList.size()];
        arrayList.toArray(sSHFTPAlgorithmArray);
        return sSHFTPAlgorithmArray;
    }

    public static SSHFTPAlgorithm getAlgorithm(String string) {
        return (SSHFTPAlgorithm)C.get(string);
    }

    private SSHFTPAlgorithm(String string, int n2) {
        this.A = string;
        this.B = n2;
    }

    public String getCode() {
        return this.A;
    }

    public int getType() {
        return this.B;
    }

    public String toString() {
        String string;
        switch (this.B) {
            case 0: {
                string = "Cipher algorithm";
                break;
            }
            case 1: {
                string = "Compression algorithm";
                break;
            }
            case 2: {
                string = "Key-exchange algorithm";
                break;
            }
            case 3: {
                string = "Key-pair algorithm";
                break;
            }
            case 4: {
                string = "MAC algorithm";
                break;
            }
            default: {
                throw new InternalError("Internal inconsistency - SSHFTPAlgorithm.toString()");
            }
        }
        return string + " " + this.A;
    }

    static {
        C = new Hashtable();
        CIPHER_3DES_CBC = new SSHFTPAlgorithm("3des-cbc", 0);
        C.put(CIPHER_3DES_CBC.getCode(), CIPHER_3DES_CBC);
        CIPHER_BLOWFISH_CBC = new SSHFTPAlgorithm("blowfish-cbc", 0);
        C.put(CIPHER_BLOWFISH_CBC.getCode(), CIPHER_BLOWFISH_CBC);
        CIPHER_AES128_CBC = new SSHFTPAlgorithm("aes128-cbc", 0);
        C.put(CIPHER_AES128_CBC.getCode(), CIPHER_AES128_CBC);
        CIPHER_AES192_CBC = new SSHFTPAlgorithm("aes192-cbc", 0);
        C.put(CIPHER_AES192_CBC.getCode(), CIPHER_AES192_CBC);
        CIPHER_AES256_CBC = new SSHFTPAlgorithm("aes256-cbc", 0);
        C.put(CIPHER_AES256_CBC.getCode(), CIPHER_AES256_CBC);
        COMPRESSION_NONE = new SSHFTPAlgorithm("none", 1);
        C.put(COMPRESSION_NONE.getCode(), COMPRESSION_NONE);
        KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1 = new SSHFTPAlgorithm("diffie-hellman-group1-sha1", 2);
        C.put(KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1.getCode(), KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1);
        KEY_RSA = new SSHFTPAlgorithm("ssh-rsa", 3);
        C.put(KEY_RSA.getCode(), KEY_RSA);
        KEY_DSA = new SSHFTPAlgorithm("ssh-dss", 3);
        C.put(KEY_DSA.getCode(), KEY_DSA);
        MAC_MD5_96 = new SSHFTPAlgorithm("hmac-md5-96", 4);
        C.put(MAC_MD5_96.getCode(), MAC_MD5_96);
        MAC_MD5 = new SSHFTPAlgorithm("hmac-md5", 4);
        C.put(MAC_MD5.getCode(), MAC_MD5);
        MAC_SHA1_96 = new SSHFTPAlgorithm("hmac-sha1-96", 4);
        C.put(MAC_SHA1_96.getCode(), MAC_SHA1_96);
        MAC_SHA1 = new SSHFTPAlgorithm("hmac-sha1", 4);
        C.put(MAC_SHA1.getCode(), MAC_SHA1);
    }
}

