/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UnixFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: UnixFileParser.java,v 1.14 2006/10/11 08:57:40 hans Exp $";
    private static final String O = "->";
    private static final char Q = 'l';
    private static final char[] R = new char[]{'-', 'p'};
    private static final char L = 'd';
    private SimpleDateFormat P;
    private SimpleDateFormat N;
    private static final int M = 8;

    public UnixFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.P = new SimpleDateFormat("MMM-dd-yyyy", locale);
        this.N = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
    }

    public static boolean isUnix(String string) {
        char c2 = string.charAt(0);
        if (c2 == 'd' || c2 == 'l') {
            return true;
        }
        for (int i2 = 0; i2 < R.length; ++i2) {
            if (c2 != R[i2]) continue;
            return true;
        }
        return false;
    }

    public FTPFile parse(String string) throws ParseException {
        Object object;
        Object object2;
        if (!UnixFileParser.isUnix(string)) {
            return null;
        }
        String[] stringArray = this.split(string);
        if (stringArray.length < 8) {
            StringBuffer stringBuffer = new StringBuffer("Unexpected number of fields in listing '");
            stringBuffer.append(string).append("' - expected minimum ").append(8).append(" fields but found ").append(stringArray.length).append(" fields");
            throw new ParseException(stringBuffer.toString(), 0);
        }
        int n2 = 0;
        char c2 = string.charAt(0);
        String string2 = stringArray[n2++];
        c2 = string2.charAt(0);
        boolean bl = false;
        boolean bl2 = false;
        if (c2 == 'd') {
            bl = true;
        } else if (c2 == 'l') {
            bl2 = true;
        }
        int n3 = 0;
        if (Character.isDigit(stringArray[n2].charAt(0))) {
            try {
                n3 = Integer.parseInt(stringArray[n2++]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string3 = stringArray[n2++];
        String string4 = stringArray[n2++];
        long l2 = 0L;
        String string5 = stringArray[n2];
        if (!Character.isDigit(string5.charAt(0)) && Character.isDigit(string4.charAt(0))) {
            string5 = string4;
            string4 = "";
        } else {
            ++n2;
        }
        try {
            l2 = Long.parseLong(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Failed to parse size: " + string5, 0);
        }
        int n4 = n2;
        Date date = null;
        StringBuffer stringBuffer = new StringBuffer(stringArray[n2++]);
        stringBuffer.append('-').append(stringArray[n2++]).append('-');
        String string6 = stringArray[n2++];
        if (string6.indexOf(58) < 0) {
            stringBuffer.append(string6);
            date = this.P.parse(stringBuffer.toString());
        } else {
            object2 = Calendar.getInstance();
            int n5 = ((Calendar)object2).get(1);
            stringBuffer.append(n5).append('-').append(string6);
            date = this.N.parse(stringBuffer.toString());
            if (date.after(((Calendar)object2).getTime())) {
                ((Calendar)object2).setTime(date);
                ((Calendar)object2).add(1, -1);
                date = ((Calendar)object2).getTime();
            }
        }
        object2 = null;
        String string7 = null;
        int n6 = 0;
        boolean bl3 = true;
        for (int i2 = n4; i2 < n4 + 3; ++i2) {
            if ((n6 = string.indexOf(stringArray[i2], n6)) < 0) {
                bl3 = false;
                break;
            }
            n6 += stringArray[i2].length();
        }
        if (bl3) {
            object = string.substring(n6).trim();
            if (!bl2) {
                object2 = object;
            } else {
                n6 = ((String)object).indexOf(O);
                if (n6 <= 0) {
                    object2 = object;
                } else {
                    int n7 = O.length();
                    object2 = ((String)object).substring(0, n6).trim();
                    if (n6 + n7 < ((String)object).length()) {
                        string7 = ((String)object).substring(n6 + n7);
                    }
                }
            }
        } else {
            throw new ParseException("Failed to retrieve name: " + string, 0);
        }
        object = new FTPFile(string, (String)object2, l2, bl, date);
        ((FTPFile)object).setGroup(string4);
        ((FTPFile)object).setOwner(string3);
        ((FTPFile)object).setLink(bl2);
        ((FTPFile)object).setLinkCount(n3);
        ((FTPFile)object).setLinkedName(string7);
        ((FTPFile)object).setPermissions(string2);
        return object;
    }
}

