/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;

public class FTPClientFactory {
    public static FTPClientInterface createClient(Protocol protocol) throws FTPException {
        return FTPClientFactory.createClient(protocol, true);
    }

    public static FTPClientInterface createClient(Protocol protocol, boolean bl) throws FTPException {
        if (protocol.equals(Protocol.FTP)) {
            return new FTPClient();
        }
        if (protocol.equals(Protocol.SFTP)) {
            SSHFTPClient sSHFTPClient = new SSHFTPClient();
            if (!bl) {
                sSHFTPClient.getValidator().setHostValidationEnabled(false);
            }
            return sSHFTPClient;
        }
        if (protocol.equals(Protocol.FTPS_EXPLICIT)) {
            SSLFTPClient sSLFTPClient = new SSLFTPClient();
            if (!bl) {
                sSLFTPClient.setValidateServer(false);
            }
            return sSLFTPClient;
        }
        if (protocol.equals(Protocol.FTPS_IMPLICIT)) {
            SSLFTPClient sSLFTPClient = new SSLFTPClient();
            sSLFTPClient.setImplicitFTPS(true);
            if (!bl) {
                sSLFTPClient.setValidateServer(false);
            }
            return sSLFTPClient;
        }
        throw new FTPException("Unknown protocol: " + protocol.toString());
    }
}

