/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.math;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class BigRegister
implements Cloneable,
Serializable {
    public static final int MAXIMUM_SIZE = 4096;
    private static final byte[] C = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] B = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final byte[] F = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final String[] H = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static final String E = "size < 2";
    private static final String D = "size > MAXIMUM_SIZE";
    private static final SecureRandom G = new SecureRandom();
    private byte[] I;
    private int J;
    private static final long A = 2535877383275048954L;

    public BigRegister(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException(E);
        }
        if (n2 > 4096) {
            throw new IllegalArgumentException(D);
        }
        this.J = n2;
        this.I = new byte[(n2 + 7) / 8];
    }

    private BigRegister(BigRegister bigRegister) {
        this.J = bigRegister.J;
        this.I = (byte[])bigRegister.I.clone();
    }

    public synchronized Object clone() {
        return new BigRegister(this);
    }

    public synchronized void and(BigRegister bigRegister) {
        if (this.J != bigRegister.J) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.I.length; ++i2) {
            int n2 = i2;
            this.I[n2] = (byte)(this.I[n2] & bigRegister.I[i2]);
        }
    }

    public synchronized void andNot(BigRegister bigRegister) {
        if (this.J != bigRegister.J) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.I.length; ++i2) {
            int n2 = i2;
            this.I[n2] = (byte)(this.I[n2] & ~bigRegister.I[i2]);
        }
    }

    public synchronized void or(BigRegister bigRegister) {
        if (this.J != bigRegister.J) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.I.length; ++i2) {
            int n2 = i2;
            this.I[n2] = (byte)(this.I[n2] | bigRegister.I[i2]);
        }
        this.A();
    }

    public synchronized void not() {
        for (int i2 = 0; i2 < this.I.length; ++i2) {
            this.I[i2] = ~this.I[i2];
        }
        this.A();
    }

    public synchronized void xor(BigRegister bigRegister) {
        if (this.J != bigRegister.J) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.I.length; ++i2) {
            int n2 = i2;
            this.I[n2] = (byte)(this.I[n2] ^ bigRegister.I[i2]);
        }
        this.A();
    }

    public synchronized void shiftLeft(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftRight(-n2);
            return;
        }
        if (n2 >= this.J) {
            this.reset();
            return;
        }
        int n3 = this.lowestSetBit();
        if (n3 == -1) {
            return;
        }
        if (n3 >= this.J - n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.I.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.I, 0, byArray, n3, n5 - n3);
        } else {
            int n6 = 8 - n4;
            int n7 = n3;
            int n8 = 0;
            while (n7 < n5) {
                byArray[n7] = (byte)(this.I[n8] << n4 | (n8 == 0 ? 0 : (this.I[n8 - 1] & 0xFF) >>> n6));
                ++n7;
                ++n8;
            }
        }
        this.I = byArray;
        this.A();
    }

    public synchronized void shiftRight(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            this.shiftLeft(-n2);
            return;
        }
        if (n2 >= this.J) {
            this.reset();
            return;
        }
        int n3 = this.highestSetBit();
        if (n3 < 0) {
            return;
        }
        if (n3 < n2) {
            this.reset();
            return;
        }
        n3 = n2 / 8;
        int n4 = n2 % 8;
        int n5 = this.I.length;
        byte[] byArray = new byte[n5];
        if (n4 == 0) {
            System.arraycopy(this.I, n3, byArray, 0, n5 - n3);
        } else {
            int n6 = 0;
            for (int i2 = n3; n6 < n5 && i2 < n5; ++n6, ++i2) {
                byArray[n6] = (byte)(((i2 == n5 - 1 ? 0 : this.I[i2 + 1] << 8) | this.I[i2] & 0xFF) >>> n4);
            }
        }
        this.I = byArray;
        this.A();
    }

    public synchronized void rotateLeft(int n2) {
        if ((n2 %= this.J) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateRight(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftRight(this.J - n2);
            this.shiftLeft(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void rotateRight(int n2) {
        if ((n2 %= this.J) == 0) {
            return;
        }
        if (n2 < 0) {
            this.rotateLeft(-n2);
        } else {
            BigRegister bigRegister = (BigRegister)this.clone();
            bigRegister.shiftLeft(this.J - n2);
            this.shiftRight(n2);
            this.or(bigRegister);
        }
    }

    public synchronized void invertOrder() {
        byte[] byArray = new byte[this.I.length];
        int n2 = 0;
        int n3 = this.J - 1;
        while (n2 < this.J) {
            if (this.testBit(n2)) {
                int n4 = n3 / 8;
                byArray[n4] = (byte)(byArray[n4] | 1 << n3 % 8);
            }
            ++n2;
            --n3;
        }
        this.I = byArray;
    }

    public synchronized boolean testBit(int n2) {
        if (n2 < 0 || n2 > this.J) {
            throw new IllegalArgumentException();
        }
        return (this.I[n2 / 8] & 1 << n2 % 8) != 0;
    }

    public synchronized boolean isSameValue(BigRegister bigRegister) {
        if (bigRegister.J != this.J) {
            return false;
        }
        return ArrayUtil.areEqual(this.I, bigRegister.I);
    }

    public synchronized int compareTo(BigRegister bigRegister) {
        if (this.J > bigRegister.J) {
            return 1;
        }
        if (this.J < bigRegister.J) {
            return -1;
        }
        return ArrayUtil.compared(this.I, bigRegister.I, true);
    }

    public synchronized void setBit(int n2) {
        if (n2 < 0 || n2 > this.J) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.I[n3] = (byte)(this.I[n3] | 1 << n2 % 8);
    }

    public synchronized void setBits(int n2, int n3, long l2) {
        if (n2 < 0 || n2 > this.J || n3 < 1 || n3 > 64 || n2 + n3 > this.J) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            if ((l2 & 1L) == 1L) {
                int n6 = n5 / 8;
                this.I[n6] = (byte)(this.I[n6] | 1 << n5 % 8);
            }
            l2 >>>= 1;
            ++n4;
            ++n5;
        }
    }

    public synchronized void clearBit(int n2) {
        if (n2 < 0 || n2 > this.J) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.I[n3] = (byte)(this.I[n3] & ~(1 << n2 % 8));
    }

    public synchronized void flipBit(int n2) {
        if (n2 < 0 || n2 > this.J) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 / 8;
        this.I[n3] = (byte)(this.I[n3] ^ 1 << n2 % 8);
    }

    public synchronized int getBit(int n2) {
        if (n2 < 0 || n2 > this.J) {
            throw new IllegalArgumentException();
        }
        return (this.I[n2 / 8] & 0xFF) >> n2 % 8 & 1;
    }

    public synchronized long getBits(int n2, int n3) {
        if (n2 < 0 || n2 > this.J || n3 < 1 || n3 > 64 || n2 + n3 > this.J) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n4 = 0;
        int n5 = n2 + n3 - 1;
        while (n4 < n3) {
            l2 = l2 << 1 | (long)((this.I[n5 / 8] & 0xFF) >> n5 % 8 & 1);
            ++n4;
            --n5;
        }
        return l2;
    }

    public synchronized int byteValue() {
        return this.I[0] & 0xFF;
    }

    public synchronized int intValue() {
        int n2 = 0;
        int n3 = this.I[n2++] & 0xFF;
        try {
            n3 |= (this.I[n2++] & 0xFF) << 8 | (this.I[n2++] & 0xFF) << 16 | (this.I[n2] & 0xFF) << 24;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return n3;
    }

    public synchronized long longValue() {
        int n2 = 0;
        long l2 = (long)this.I[n2++] & 0xFFL;
        try {
            l2 |= ((long)this.I[n2++] & 0xFFL) << 8 | ((long)this.I[n2++] & 0xFFL) << 16 | ((long)this.I[n2++] & 0xFFL) << 24 | ((long)this.I[n2++] & 0xFFL) << 32 | ((long)this.I[n2++] & 0xFFL) << 40 | ((long)this.I[n2++] & 0xFFL) << 48 | ((long)this.I[n2] & 0xFFL) << 56;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return l2;
    }

    public synchronized BigRegister valueOf(long l2) {
        BigRegister bigRegister = new BigRegister(this.J);
        int n2 = Math.min(8, this.I.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            bigRegister.I[i2] = (byte)(l2 >>> 8 * i2);
        }
        bigRegister.A();
        return bigRegister;
    }

    public synchronized void reset() {
        ArrayUtil.clear(this.I);
    }

    public synchronized void atRandom() {
        this.atRandom(G);
    }

    public synchronized void atRandom(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.I);
        this.A();
    }

    public synchronized void load(BigRegister bigRegister) {
        if (this.J != bigRegister.J) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(bigRegister.I, 0, this.I, 0, this.I.length);
    }

    public synchronized void load(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = this.I.length;
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray, 0, this.I, 0, n2);
        if (n2 < n3) {
            ArrayUtil.clear(this.I, n2, n3 - n2);
        }
        this.A();
    }

    public synchronized byte[] toByteArray() {
        return (byte[])this.I.clone();
    }

    public synchronized int getSize() {
        return this.J;
    }

    public synchronized int countSetBits() {
        int n2 = 0;
        int n3 = this.I.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = this.I[i2];
            n2 += by < 0 ? 8 : C[by & 0xFF];
        }
        return n2;
    }

    public synchronized int highestSetBit() {
        int n2;
        for (n2 = this.I.length - 1; n2 > 0 && this.I[n2] == 0; --n2) {
        }
        if (this.I[n2] == 0) {
            return -1;
        }
        int n3 = this.I[n2] >>> 4 & 0xF;
        int n4 = 4;
        if (n3 == 0) {
            n3 = this.I[n2] & 0xF;
            n4 -= 4;
        }
        return n2 * 8 + (n4 += B[n3]);
    }

    public synchronized int lowestSetBit() {
        int n2;
        int n3 = this.I.length;
        for (n2 = 0; n2 < n3 && this.I[n2] == 0; ++n2) {
        }
        if (n2 == n3) {
            return -1;
        }
        int n4 = this.I[n2] & 0xF;
        int n5 = 0;
        if (n4 == 0) {
            n4 = this.I[n2] >>> 4 & 0xF;
            n5 += 4;
        }
        return n2 * 8 + (n5 += F[n4]);
    }

    public synchronized String toString() {
        int n2;
        int n3;
        String string;
        StringBuffer stringBuffer = new StringBuffer(8 * this.I.length + 64);
        stringBuffer.append("Binary dump of a BigRegister [").append(this.J).append("-bit]...\n");
        stringBuffer.append("Byte #:|........|........|........|........|........|........|........|........|\n");
        int n4 = this.I.length;
        int n5 = n4-- % 8;
        if (n5 != 0) {
            string = "      " + String.valueOf(this.I.length);
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            for (n3 = 0; n3 < 8 - n5; ++n3) {
                stringBuffer.append("         ");
            }
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.I[n4--] & 0xFF;
                stringBuffer.append(' ').append(H[n2 >>> 4 & 0xF]).append(H[n2 & 0xF]);
            }
            stringBuffer.append('\n');
        }
        int n6 = (n4 + 1) / 8;
        for (n3 = 0; n3 < n6; ++n3) {
            string = "      " + String.valueOf(8 * (n6 - n3));
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            for (int i2 = 0; i2 < 8; ++i2) {
                n2 = this.I[n4--] & 0xFF;
                stringBuffer.append(' ').append(H[n2 >>> 4 & 0xF]).append(H[n2 & 0xF]);
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private synchronized void A() {
        int n2 = 8 - this.J % 8;
        if (n2 != 8) {
            int n3 = this.I.length - 1;
            this.I[n3] = (byte)(this.I[n3] & 255 >>> n2);
        }
    }
}

