/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.tools;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.StringTokenizer;
import xjava.security.Cipher;
import xjava.security.SecretKey;

public final class KAT {
    static final String S = "$Revision: 1.2 $";
    static final String D = "<as stated on the submission cover sheet>";
    boolean M = false;
    boolean T = false;
    String I = null;
    String J = null;
    String V = null;
    String O = null;
    File P = null;
    int[] K = new int[]{128, 192, 256};
    final String Q = "ecb_vk.txt";
    final String A = "ecb_vt.txt";
    long U;
    long H;
    long G;
    Class R = null;
    Method F = null;
    Method N = null;
    Method L = null;
    Method C = null;
    Cipher B = null;
    boolean E = true;

    public static void main(String[] stringArray) {
        System.out.println("NIST Known Answer Tests data generator/exerciser\n\n$Revision: 1.2 $\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        KAT kAT = new KAT();
        kAT.A(stringArray);
        kAT.B();
    }

    private void A(String[] stringArray) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            this.A();
        }
        System.out.println("(type \"java cryptix.tools.KAT\" with no arguments for help)\n\n");
        int n3 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n3 >= n2) break;
                string = stringArray[n3];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-k")) {
                this.M = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-t")) {
                this.T = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.J = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.I = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-p")) {
                this.V = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            this.O = string;
        }
        if (this.O == null) {
            KAT.A("Missing cipher algorithm name");
        }
        if (this.O.length() > 1 && (this.O.startsWith("\"") || this.O.startsWith("'"))) {
            this.O = this.O.substring(2, this.O.length() - 2);
        }
        if (this.V == null) {
            this.V = this.O;
        }
        if (this.J != null) {
            int n4 = 0;
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(this.J, ", \t\"");
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                if (n5 <= 0) {
                    KAT.A("Negative key length not allowed: " + n5);
                }
                if (n4 == 3) {
                    KAT.A("Only three key-length values are allowed.");
                }
                nArray[n4++] = n5;
            }
            if (n4 != 0) {
                this.K = new int[n4];
                System.arraycopy(nArray, 0, this.K, 0, n4);
            }
        }
        if (!this.M && !this.T) {
            this.T = true;
            this.M = true;
        }
        if (this.I == null) {
            this.I = System.getProperty("user.dir");
        }
        this.P = new File(this.I);
        if (!this.P.isDirectory()) {
            KAT.A("Destination <" + this.P.getName() + "> is not a directory");
        }
        try {
            this.R = Class.forName(this.V + "." + this.O + "_Algorithm");
            Method[] methodArray = this.R.getDeclaredMethods();
            for (n3 = 0; n3 < methodArray.length; ++n3) {
                String string2 = methodArray[n3].getName();
                int n6 = methodArray[n3].getParameterTypes().length;
                if (string2.equals("blockSize")) {
                    this.F = methodArray[n3];
                    continue;
                }
                if (string2.equals("makeKey") && n6 == 1) {
                    this.N = methodArray[n3];
                    continue;
                }
                if (string2.equals("blockEncrypt") && n6 == 3) {
                    this.L = methodArray[n3];
                    continue;
                }
                if (!string2.equals("blockDecrypt") || n6 != 3) continue;
                this.C = methodArray[n3];
            }
            if (this.F == null) {
                throw new NoSuchMethodException("blockSize()");
            }
            if (this.N == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.L == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.C == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            KAT.D("Unable to find a " + this.O + "_Algorithm class");
            this.R = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            KAT.D("Unable to find method " + noSuchMethodException.getMessage() + " in " + this.O + "_Algorithm class");
            this.R = null;
        }
        try {
            this.B = Cipher.getInstance(this.O + "/ECB", this.V);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            KAT.A("Unable to locate Security Provider: " + this.V);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KAT.A("Unable to locate an implementation for Cipher: " + this.O + "/ECB");
        }
        this.E = this.R != null;
    }

    static void A(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void D(String string) {
        System.out.println("KAT: " + string + "...");
    }

    void A() {
        System.out.println("NAME\n  KAT: A Known Answer Tests data generator/exerciser for any block\n  cipher algorithm.\n\nSYNTAX\n  java cryptix.tools.KAT\n    [ -k | -t ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    [ -p <provider>]\n    <cipher>\n\nDESCRIPTION\n  For a designated symmetric block cipher algorithm, KAT generates\n  and exercises Known Answer Tests data for both Variable Key and\n  Variable Text suites.\n  KAT's output file format conforms to the layout described in\n  Section 3 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES)\n  Candidate Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -k   Generate data for variable-key tests only.  By default KAT\n       generates both variable-key and variable-text test uites.\n\n  -t   Generate data for variable-text tests only. By default KAT\n       generates both variable-key and variable-text test suites.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where output files: \"ecb_vk.txt\"\n       and \"ecb_vt.txt\" will be generated.  If this destination\n       directory is not specified, those files will be placed in\n       the current user directory.\n\n  -p <provider>\n       Name of the Security Provider for the designated algorithm.\n       If omitted, then assumes provider has the same name as the\n       algorithm itself.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void B() {
        long l2 = System.currentTimeMillis();
        try {
            if (this.M) {
                this.C("ecb_vk.txt");
            }
            if (this.T) {
                this.B("ecb_vt.txt");
            }
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            KAT.A("Key Exception encountered:\n" + keyException.getMessage());
        }
        KAT.D("Java interpreter used: Version " + System.getProperty("java.version"));
        KAT.D("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        KAT.D("Total execution time (ms): " + (System.currentTimeMillis() - l2));
        KAT.D("During this time, " + this.O + ":");
        KAT.D("  Encrypted " + this.U + " blocks");
        KAT.D("  Decrypted " + this.H + " blocks");
        KAT.D("  Created " + this.G + " session keys");
    }

    void C(String string) throws KeyException {
        File file = new File(this.P, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.A("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Key Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.O);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.E) {
            try {
                for (int i2 = 0; i2 < this.K.length; ++i2) {
                    this.A(this.K[i2], printWriter);
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                KAT.D("Exception while invoking a method in " + this.O + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                KAT.A("Exception encountered in a " + this.O + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            for (int i3 = 0; i3 < this.K.length; ++i3) {
                this.D(this.K[i3], printWriter);
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void A(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.D("Generating and testing Variable Key KAT (short); key size: " + n2);
        KAT.D("Using Reflection API methods");
        Object[] objectArray = new Object[]{};
        int n3 = n2 / 8;
        int n4 = (Integer)this.F.invoke(null, objectArray);
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("PT=" + Hex.toString(byArray2));
        printWriter.println();
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                printWriter.println("I=" + ++n5);
                byArray[i2] = (byte)(1 << 7 - i3);
                printWriter.println("KEY=" + Hex.toString(byArray));
                objectArray = new Object[]{byArray};
                Object object = this.N.invoke(null, objectArray);
                ++this.G;
                objectArray = new Object[]{byArray2, new Integer(0), object};
                byte[] byArray3 = (byte[])this.L.invoke(null, objectArray);
                ++this.U;
                printWriter.print("CT=" + Hex.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.C.invoke(null, objectArray);
                ++this.H;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
            }
            byArray[i2] = 0;
        }
    }

    void D(int n2, PrintWriter printWriter) throws KeyException {
        KAT.D("Generating and testing Variable Key KAT (short); key size: " + n2);
        KAT.D("Using IJCE API methods");
        int n3 = n2 / 8;
        int n4 = this.B.blockSize();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("PT=" + Hex.toString(byArray2));
        printWriter.println();
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                printWriter.println("I=" + ++n5);
                byArray[i2] = (byte)(1 << 7 - i3);
                printWriter.println("KEY=" + Hex.toString(byArray));
                _A _A2 = new _A(byArray);
                this.B.initEncrypt(_A2);
                ++this.G;
                byte[] byArray3 = this.B.crypt(byArray2);
                ++this.U;
                printWriter.print("CT=" + Hex.toString(byArray3));
                this.B.initDecrypt(_A2);
                ++this.G;
                byte[] byArray4 = this.B.crypt(byArray3);
                ++this.H;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
            }
            byArray[i2] = 0;
        }
    }

    void B(String string) throws KeyException {
        File file = new File(this.P, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.A("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Text Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.O);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.E) {
            try {
                for (int i2 = 0; i2 < this.K.length; ++i2) {
                    this.C(this.K[i2], printWriter);
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                KAT.D("Exception while invoking a method in " + this.O + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                KAT.A("Exception encountered in a " + this.O + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            for (int i3 = 0; i3 < this.K.length; ++i3) {
                this.B(this.K[i3], printWriter);
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void C(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.D("Generating and testing Variable Text KAT (short); key size: " + n2);
        KAT.D("Using Reflection API methods");
        Object[] objectArray = new Object[]{};
        byte[] byArray = new byte[n2 / 8];
        int n3 = (Integer)this.F.invoke(null, objectArray);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        objectArray = new Object[]{byArray};
        Object object = this.N.invoke(null, objectArray);
        ++this.G;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("KEY=" + Hex.toString(byArray));
        printWriter.println();
        objectArray = new Object[3];
        objectArray[1] = new Integer(0);
        objectArray[2] = object;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                printWriter.println("I=" + ++n4);
                byArray2[i2] = (byte)(1 << 7 - i3);
                printWriter.println("PT=" + Hex.toString(byArray2));
                objectArray[0] = byArray2;
                byte[] byArray3 = (byte[])this.L.invoke(null, objectArray);
                ++this.U;
                printWriter.print("CT=" + Hex.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.C.invoke(null, objectArray);
                ++this.H;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
            }
            byArray2[i2] = 0;
        }
    }

    void B(int n2, PrintWriter printWriter) throws KeyException {
        KAT.D("Generating and testing Variable Text KAT (short); key size: " + n2);
        KAT.D("Using IJCE API methods");
        byte[] byArray = new byte[n2 / 8];
        int n3 = this.B.blockSize();
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        _A _A2 = new _A(byArray);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("KEY=" + Hex.toString(byArray));
        printWriter.println();
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                printWriter.println("I=" + ++n4);
                byArray2[i2] = (byte)(1 << 7 - i3);
                printWriter.println("PT=" + Hex.toString(byArray2));
                this.B.initEncrypt(_A2);
                ++this.G;
                byte[] byArray3 = this.B.crypt(byArray2);
                ++this.U;
                printWriter.print("CT=" + Hex.toString(byArray3));
                this.B.initDecrypt(_A2);
                ++this.G;
                byte[] byArray4 = this.B.crypt(byArray3);
                ++this.H;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
            }
            byArray2[i2] = 0;
        }
    }

    final class _A
    implements SecretKey {
        byte[] A;

        public _A(byte[] byArray) {
            this.A = (byte[])byArray.clone();
        }

        public String getAlgorithm() {
            return "<ANY>";
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.A.clone();
        }
    }
}

