/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.AsymmetricCipher;
import xjava.security.Cipher;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RawRSACipher
extends Cipher
implements AsymmetricCipher,
Cloneable {
    private static final int \u00a2 = 1;
    private BigInteger \u00a4;
    private BigInteger \u00a3;
    private BigInteger z;
    private BigInteger y;
    private BigInteger w;
    private int x;
    private byte[] v;

    public RawRSACipher() {
        super(false, false, "CryptixEDT");
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA public key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)key;
        this.\u00a4 = cryptixRSAPublicKey.getModulus();
        this.\u00a3 = cryptixRSAPublicKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.z = rSAFactors.getP();
            this.y = rSAFactors.getQ();
            this.w = rSAFactors.getInverseOfQModP();
        }
        this.D();
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA private key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)key;
        this.\u00a4 = cryptixRSAPrivateKey.getModulus();
        this.\u00a3 = cryptixRSAPrivateKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.z = rSAFactors.getP();
            this.y = rSAFactors.getQ();
            this.w = rSAFactors.getInverseOfQModP();
        }
        this.D();
    }

    private void D() {
        this.x = BI.getMagnitude(this.\u00a4).length;
        this.v = new byte[this.x];
    }

    protected int enginePlaintextBlockSize() {
        if (this.x == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.x - 1;
    }

    protected int engineCiphertextBlockSize() {
        if (this.x == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.x;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = this.getState() == 1 ? this.enginePlaintextBlockSize() : this.engineCiphertextBlockSize();
        int n6 = this.getState() == 1 ? this.engineCiphertextBlockSize() : this.enginePlaintextBlockSize();
        int n7 = n3 / n5;
        for (int i2 = 0; i2 < n7; ++i2) {
            ArrayUtil.clear(this.v);
            System.arraycopy(byArray, n2, this.v, this.v.length - n5, n5);
            BigInteger bigInteger = new BigInteger(1, this.v);
            if (bigInteger.compareTo(this.\u00a4) >= 0) {
                throw new CryptixException(this.getAlgorithm() + ": Input block value is out of range (>= modulus)");
            }
            BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.\u00a4, this.\u00a3, this.z, this.y, this.w);
            byte[] byArray3 = BI.getMagnitude(bigInteger2);
            if (byArray3.length > n6) {
                throw new ArrayIndexOutOfBoundsException("Decryption failed, wrong key?");
            }
            ArrayUtil.clear(this.v);
            System.arraycopy(byArray3, 0, this.v, n6 - byArray3.length, byArray3.length);
            System.arraycopy(this.v, 0, byArray2, n4, n6);
            n2 += n5;
            n4 += n6;
        }
        return n7 * n6;
    }

    public static final void main(String[] stringArray) {
        try {
            RawRSACipher.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
        SecureRandom secureRandom = new SecureRandom();
        long l2 = System.currentTimeMillis();
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        long l3 = System.currentTimeMillis() - l2;
        printWriter.println("Keygen: " + (float)l3 / 1000.0f + " seconds");
        RawRSACipher rawRSACipher = new RawRSACipher();
        rawRSACipher.B(printWriter, keyPair, secureRandom);
    }

    private void B(PrintWriter printWriter, KeyPair keyPair, SecureRandom secureRandom) throws KeyException {
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)keyPair.getPrivate();
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)keyPair.getPublic();
        long l2 = System.currentTimeMillis();
        this.initEncrypt(cryptixRSAPublicKey);
        BigInteger bigInteger = this.\u00a3;
        byte[] byArray = new byte[this.getPlaintextBlockSize()];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = this.crypt(byArray);
        long l3 = System.currentTimeMillis();
        this.initDecrypt(cryptixRSAPrivateKey);
        byte[] byArray3 = this.crypt(byArray2);
        long l4 = System.currentTimeMillis();
        printWriter.println("         n = " + BI.dumpString(this.\u00a4));
        printWriter.println("         e = " + BI.dumpString(bigInteger));
        printWriter.println("         d = " + BI.dumpString(this.\u00a3));
        printWriter.println("         p = " + BI.dumpString(this.z));
        printWriter.println("         q = " + BI.dumpString(this.y));
        printWriter.println("q^-1 mod p = " + BI.dumpString(this.w));
        printWriter.println(" plaintext = " + Hex.toString(byArray) + "\n");
        printWriter.println("ciphertext = " + Hex.toString(byArray2) + "\n");
        if (!ArrayUtil.areEqual(byArray, byArray3)) {
            printWriter.println("DECRYPTION FAILED!\n");
            printWriter.println("  computed = " + Hex.toString(byArray3) + "\n");
        }
        printWriter.println("Encrypt: " + (float)(l3 - l2) / 1000.0f + " seconds");
        printWriter.println("Decrypt: " + (float)(l4 - l3) / 1000.0f + " seconds");
    }
}

