/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.mode.A;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class PCBC
extends A {
    private byte[] \u00c1;

    public PCBC() {
        super(false, false, "CryptixEDT");
    }

    public PCBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public PCBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.\u00c1 = new byte[this.\u00aa];
    }

    protected int engineBlockSize() {
        return this.\u00aa;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.\u00a5 != null) {
            System.arraycopy(this.\u00a5, 0, this.\u00b5, 0, this.\u00aa);
        }
        ArrayUtil.clear(this.\u00c1);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.\u00a5 != null) {
            System.arraycopy(this.\u00a5, 0, this.\u00b5, 0, this.\u00aa);
        }
        ArrayUtil.clear(this.\u00c1);
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.\u00b5 == null) {
            throw new InvalidParameterException("PCBC: IV is not set");
        }
        if (n3 <= 0) {
            return 0;
        }
        switch (this.getState()) {
            case 1: {
                for (int i2 = 0; i2 < this.\u00aa; ++i2) {
                    int n5 = i2;
                    this.\u00b5[n5] = (byte)(this.\u00b5[n5] ^ byArray[n2 + i2]);
                    int n6 = i2;
                    this.\u00c1[n6] = (byte)(this.\u00c1[n6] ^ this.\u00b5[i2]);
                }
                this.cipher.update(this.\u00c1, 0, this.\u00aa, this.\u00b5, 0);
                System.arraycopy(this.\u00b5, 0, byArray2, n4, this.\u00aa);
                System.arraycopy(byArray, n2, this.\u00c1, 0, this.\u00aa);
                break;
            }
            case 2: {
                this.cipher.update(byArray, n2, this.\u00aa, this.\u00c1, 0);
                for (int i3 = 0; i3 < this.\u00aa; ++i3) {
                    byArray2[n4 + i3] = (byte)(this.\u00b5[i3] ^ this.\u00c1[i3]);
                    this.\u00b5[i3] = (byte)(byArray[n2 + i3] ^ byArray2[n4 + i3]);
                }
                break;
            }
            default: {
                throw new CryptixException("PCBC: Cipher not initialized");
            }
        }
        return this.\u00aa;
    }
}

