/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.A;

public abstract class SHA512Base
extends A {
    private static final int k = 128;
    private static final long[] i = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private final long[] j;
    private final long[] h;

    public SHA512Base(String string, int n2) {
        super(string, 128, n2, 1);
        this.j = new long[8];
        this.h = new long[80];
        this.coreReset();
    }

    protected SHA512Base(SHA512Base sHA512Base) {
        super(sHA512Base.getAlgorithm(), sHA512Base);
        this.j = (long[])sHA512Base.j.clone();
        this.h = (long[])sHA512Base.h.clone();
    }

    protected abstract void loadInitialValues(long[] var1);

    protected abstract void generateDigest(long[] var1, byte[] var2, int var3);

    protected void coreDigest(byte[] byArray, int n2) {
        this.generateDigest(this.j, byArray, n2);
    }

    protected void coreReset() {
        this.loadInitialValues(this.j);
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int n3;
        long[] lArray = this.h;
        for (n3 = 0; n3 < 16; ++n3) {
            lArray[n3] = (long)byArray[n2++] << 56 | ((long)byArray[n2++] & 0xFFL) << 48 | ((long)byArray[n2++] & 0xFFL) << 40 | ((long)byArray[n2++] & 0xFFL) << 32 | ((long)byArray[n2++] & 0xFFL) << 24 | ((long)byArray[n2++] & 0xFFL) << 16 | ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2++] & 0xFFL;
        }
        for (n3 = 16; n3 < 80; ++n3) {
            lArray[n3] = this.C(lArray[n3 - 2]) + lArray[n3 - 7] + this.D(lArray[n3 - 15]) + lArray[n3 - 16];
        }
        long l2 = this.j[0];
        long l3 = this.j[1];
        long l4 = this.j[2];
        long l5 = this.j[3];
        long l6 = this.j[4];
        long l7 = this.j[5];
        long l8 = this.j[6];
        long l9 = this.j[7];
        for (int i2 = 0; i2 < 80; ++i2) {
            long l10 = l9 + this.A(l6) + this.A(l6, l7, l8) + i[i2] + lArray[i2];
            long l11 = this.B(l2) + this.B(l2, l3, l4);
            l9 = l8;
            l8 = l7;
            l7 = l6;
            l6 = l5 + l10;
            l5 = l4;
            l4 = l3;
            l3 = l2;
            l2 = l10 + l11;
        }
        this.j[0] = this.j[0] + l2;
        this.j[1] = this.j[1] + l3;
        this.j[2] = this.j[2] + l4;
        this.j[3] = this.j[3] + l5;
        this.j[4] = this.j[4] + l6;
        this.j[5] = this.j[5] + l7;
        this.j[6] = this.j[6] + l8;
        this.j[7] = this.j[7] + l9;
    }

    private final long A(long l2, long l3, long l4) {
        return l2 & l3 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
    }

    private final long B(long l2, long l3, long l4) {
        return l2 & l3 ^ l2 & l4 ^ l3 & l4;
    }

    private final long B(long l2) {
        return this.B(28, l2) ^ this.B(34, l2) ^ this.B(39, l2);
    }

    private final long A(long l2) {
        return this.B(14, l2) ^ this.B(18, l2) ^ this.B(41, l2);
    }

    private final long D(long l2) {
        return this.B(1, l2) ^ this.B(8, l2) ^ this.A(7, l2);
    }

    private final long C(long l2) {
        return this.B(19, l2) ^ this.B(61, l2) ^ this.A(6, l2);
    }

    private final long A(int n2, long l2) {
        return l2 >>> n2;
    }

    private final long B(int n2, long l2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }
}

