/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.A;

public final class RIPEMD128
extends A
implements Cloneable {
    private static final int[] _ = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2};
    private static final int[] a = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14};
    private static final int[] Z = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12};
    private static final int[] b = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8};
    private int[] Y = new int[4];
    private int[] c = new int[16];

    public RIPEMD128() {
        super("RIPEMD128", 16, 0);
        this.coreReset();
    }

    private RIPEMD128(RIPEMD128 rIPEMD128) {
        super(rIPEMD128.getAlgorithm(), rIPEMD128);
        this.Y = (int[])rIPEMD128.Y.clone();
        this.c = (int[])rIPEMD128.c.clone();
    }

    public Object clone() {
        return new RIPEMD128(this);
    }

    protected void coreDigest(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray[n2 + (i2 * 4 + i3)] = (byte)(this.Y[i2] >>> 8 * i3 & 0xFF);
            }
        }
    }

    protected void coreReset() {
        this.Y[0] = 1732584193;
        this.Y[1] = -271733879;
        this.Y[2] = -1732584194;
        this.Y[3] = 271733878;
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        for (n9 = 0; n9 < 16; ++n9) {
            this.c[n9] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
        int n10 = n8 = this.Y[0];
        int n11 = n7 = this.Y[1];
        int n12 = n6 = this.Y[2];
        int n13 = n5 = this.Y[3];
        for (n9 = 0; n9 < 16; ++n9) {
            n4 = Z[n9];
            n3 = n10 + (n11 ^ n12 ^ n13) + this.c[n9];
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = b[n9];
            n3 = n8 + (n7 & n5 | n6 & ~n5) + this.c[a[n9]] + 1352829926;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
        }
        for (n9 = 16; n9 < 32; ++n9) {
            n4 = Z[n9];
            n3 = n10 + (n11 & n12 | ~n11 & n13) + this.c[_[n9]] + 1518500249;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = b[n9];
            n3 = n8 + ((n7 | ~n6) ^ n5) + this.c[a[n9]] + 1548603684;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
        }
        for (n9 = 32; n9 < 48; ++n9) {
            n4 = Z[n9];
            n3 = n10 + ((n11 | ~n12) ^ n13) + this.c[_[n9]] + 1859775393;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = b[n9];
            n3 = n8 + (n7 & n6 | ~n7 & n5) + this.c[a[n9]] + 1836072691;
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
        }
        for (n9 = 48; n9 < 64; ++n9) {
            n4 = Z[n9];
            n3 = n10 + (n11 & n13 | n12 & ~n13) + this.c[_[n9]] + -1894007588;
            n10 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n3 << n4 | n3 >>> 32 - n4;
            n4 = b[n9];
            n3 = n8 + (n7 ^ n6 ^ n5) + this.c[a[n9]];
            n8 = n5;
            n5 = n6;
            n6 = n7;
            n7 = n3 << n4 | n3 >>> 32 - n4;
        }
        n3 = this.Y[1] + n12 + n5;
        this.Y[1] = this.Y[2] + n13 + n8;
        this.Y[2] = this.Y[3] + n10 + n7;
        this.Y[3] = this.Y[0] + n11 + n6;
        this.Y[0] = n3;
    }
}

