/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.lang;

import com.enterprisedt.cryptix.asn1.lang.ASNBitString;
import com.enterprisedt.cryptix.asn1.lang.ASNBoolean;
import com.enterprisedt.cryptix.asn1.lang.ASNInteger;
import com.enterprisedt.cryptix.asn1.lang.ASNNull;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNObjectIdentifier;
import com.enterprisedt.cryptix.asn1.lang.ASNOctetString;
import com.enterprisedt.cryptix.asn1.lang.ASNPrintableString;
import com.enterprisedt.cryptix.asn1.lang.ASNSequence;
import com.enterprisedt.cryptix.asn1.lang.ASNSequenceOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSet;
import com.enterprisedt.cryptix.asn1.lang.ASNSetOf;
import com.enterprisedt.cryptix.asn1.lang.ASNTaggedType;
import com.enterprisedt.cryptix.asn1.lang.ASNTime;
import com.enterprisedt.cryptix.asn1.lang.ASNType;
import com.enterprisedt.cryptix.asn1.lang.ASNTypeAlias;
import com.enterprisedt.cryptix.asn1.lang.Node;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.asn1.lang.ParserTreeConstants;
import com.enterprisedt.cryptix.asn1.lang.ParserVisitor;
import com.enterprisedt.cryptix.asn1.lang.Tag;
import com.enterprisedt.cryptix.util.core.Debug;
import java.io.IOException;
import java.util.Vector;

public class SimpleNode
implements ASNObject {
    private static final boolean B = Debug.GLOBAL_DEBUG;
    private static final int A = B ? Debug.getLevel("SimpleNode") : 0;
    protected ASNObject parent;
    protected ASNObject[] children;
    protected int id;
    protected Parser parser;
    protected String name;
    protected Tag tag;
    protected boolean optional;
    protected Object value;
    protected Object defaultValue;

    public SimpleNode(int n2) {
        this.id = n2;
    }

    public SimpleNode(Parser parser, int n2) {
        this(n2);
        this.parser = parser;
    }

    public static final SimpleNode getInstance(Parser parser, Tag tag) {
        int n2 = tag.getClazz();
        if (n2 != 0) {
            return null;
        }
        int n3 = tag.getValue();
        SimpleNode simpleNode = null;
        switch (n3) {
            case 1: {
                simpleNode = new ASNBoolean(parser, 4);
                break;
            }
            case 2: {
                simpleNode = new ASNInteger(parser, 5);
                break;
            }
            case 3: {
                simpleNode = new ASNBitString(parser, 6);
                break;
            }
            case 4: {
                simpleNode = new ASNOctetString(parser, 7);
                break;
            }
            case 5: {
                simpleNode = new ASNNull(parser, 8);
                break;
            }
            case 6: {
                simpleNode = new ASNObjectIdentifier(parser, 9);
                break;
            }
            case 16: {
                simpleNode = new ASNSequence(parser, 10);
                break;
            }
            case 48: {
                simpleNode = new ASNSequenceOf(parser, 11);
                break;
            }
            case 17: {
                simpleNode = new ASNSet(parser, 12);
                break;
            }
            case 49: {
                simpleNode = new ASNSetOf(parser, 13);
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                simpleNode = new ASNPrintableString(parser, 16);
                break;
            }
            case 23: {
                simpleNode = new ASNTime(parser, 17);
            }
        }
        return simpleNode;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = (ASNObject)node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public ASNObject getParent() {
        SimpleNode simpleNode = this;
        while ((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null && simpleNode.id == 2) {
        }
        return simpleNode;
    }

    public void jjtAddChild(Node node, int n2) {
        if (this.children == null) {
            this.children = new ASNObject[n2 + 1];
        } else if (n2 >= this.children.length) {
            ASNObject[] aSNObjectArray = new ASNObject[n2 + 1];
            System.arraycopy(this.children, 0, aSNObjectArray, 0, this.children.length);
            this.children = aSNObjectArray;
        }
        this.children[n2] = (ASNObject)node;
    }

    public Node jjtGetChild(int n2) {
        return this.children[n2];
    }

    public ASNObject getChild(int n2) {
        return (ASNObject)this.jjtGetChild(n2);
    }

    public ASNObject[] getChildren() {
        return this.children;
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(ParserVisitor parserVisitor, Object object) throws IOException {
        return parserVisitor.visit(this, object);
    }

    public Object childrenAccept(ParserVisitor parserVisitor, Object object) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                this.children[i2].jjtAccept(parserVisitor, object);
                vector.addElement(this.children[i2].getValue());
            }
        }
        return vector;
    }

    public String toString() {
        String string = "<ASNObject name=\"" + this.name + "\" type=\"";
        string = string + ParserTreeConstants.jjtNodeName[this.id] + "\"";
        string = string + " default=\"" + this.defaultValue + "\"";
        string = string + " optional=\"" + (this.optional ? "yes" : "no") + "\" />";
        return string;
    }

    public String toString(String string) {
        String string2 = string + this.toString();
        return string2;
    }

    public Parser getParser() {
        return this.parser;
    }

    public int getID() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ASNObject getComponent(String string) {
        if (B && A > 8) {
            Debug.log("SimpleNode - IN: \"" + string + "\"");
        }
        ASNObject aSNObject = (ASNObject)Parser.resolve(string);
        if (B && A > 8) {
            Debug.log("SimpleNode - OUT: " + aSNObject);
        }
        return aSNObject;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public void setValue(Object object) {
        if (this.value != null && B && A > 1) {
            Debug.log("SimpleNode - Is already assigned: " + object);
        }
        this.value = object;
    }

    public Object getValue() {
        Object object = null;
        if (this.id == 3) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            if (simpleNode != null) {
                object = simpleNode.getValue();
            }
        } else {
            object = this.value;
        }
        return object;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public Object getDefaultValue() {
        if (this instanceof ASNType) {
            SimpleNode simpleNode = (SimpleNode)this.children[0];
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTaggedType) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTypeAlias) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        return this.defaultValue;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public void dump(String string) {
        if (this instanceof ASNType) {
            this.D(this, string);
        } else if (this instanceof ASNTaggedType) {
            this.A(this, string);
        } else if (this instanceof ASNTypeAlias) {
            this.B(this, string);
        } else {
            this.C(this, string);
        }
    }

    public Object accept(ParserVisitor parserVisitor, Object object) throws IOException {
        return this.jjtAccept(parserVisitor, object);
    }

    private void D(SimpleNode simpleNode, String string) {
        if (B && A > 8) {
            string = string + "T.";
        }
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.children[0];
        simpleNode2.dump(string);
    }

    private void A(SimpleNode simpleNode, String string) {
        if (B && A > 8) {
            string = string + "TT.";
        }
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        System.out.println(simpleNode2.toString(string + simpleNode.getTag()));
    }

    private void B(SimpleNode simpleNode, String string) {
        if (B && A > 8) {
            string = string + "A.";
        }
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        simpleNode2.dump(string);
    }

    private void C(SimpleNode simpleNode, String string) {
        if (B && A > 8) {
            string = string + "S.";
        }
        System.out.println(simpleNode.toString(string));
        this.A(this.children, string);
    }

    private void A(ASNObject[] aSNObjectArray, String string) {
        if (aSNObjectArray == null) {
            return;
        }
        string = string + "+ ";
        int n2 = aSNObjectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SimpleNode simpleNode = (SimpleNode)aSNObjectArray[i2];
            if (simpleNode == null) continue;
            simpleNode.dump(string);
        }
    }
}

