/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.visualize.Row;

public class RowList {
    private List rows = new ArrayList();

    public void add(int n, Vertex vertex) {
        if (this.rows.size() < n + 1) {
            int n2 = n - this.rows.size() + 1;
            for (int i = 0; i < n2; ++i) {
                this.rows.add(new Row(n - n2 + i));
            }
        }
        ((Row)this.rows.get(n)).add(vertex);
    }

    public int getDepth() {
        return this.rows.size();
    }

    public Row get(int n) {
        return (Row)this.rows.get(n);
    }

    public int getRow(Vertex vertex) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            if (!((Row)this.rows.get(i)).contains(vertex)) continue;
            return i;
        }
        return -1;
    }

    public int getWidth() {
        int n = 0;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            int n2 = row.getWidth();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getWidth(int n) {
        return ((Row)this.rows.get(n)).getWidth();
    }

    public int getColumn(Vertex vertex) {
        int n = this.getRow(vertex);
        if (n < 0) {
            return -1;
        }
        List list = this.get(n).getVertices();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (!list.get(i).equals(vertex)) continue;
            return i;
        }
        return -1;
    }

    public void dump() {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            System.err.println(i + ": " + this.get(i).getVertices());
        }
    }

    public void optimize() {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            this.get(i).optimize();
        }
    }
}

