/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.util.Iterator;
import java.util.Set;
import org.drools.visualize.RowList;
import org.drools.visualize.VertexFunctions;

public class ReteooLayout
extends AbstractLayout {
    public static final String COORDS = "drools.ReteooLayout.coords";
    private static final int COLUMN_SPACE = 20;
    private static final int ROW_HEIGHT_MULTIPLIER = 3;
    private RowList rowList;
    private VertexFunctions vertexFunctions;
    private int columnWidth;
    private int rowHeight;

    public ReteooLayout(Graph graph, VertexFunctions vertexFunctions, RowList rowList) {
        super(graph);
        this.vertexFunctions = vertexFunctions;
        this.rowList = rowList;
        this.computeSize();
    }

    public VertexFunctions getVertexFunctions() {
        return this.vertexFunctions;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getPreferredWidth() {
        return this.rowList.getWidth() * this.columnWidth;
    }

    public int getPreferredHeight() {
        return this.rowList.getDepth() * this.getRowHeight() * 3;
    }

    protected void computeSize() {
        Set set = this.getGraph().getVertices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            int n = this.vertexFunctions.getShapeDimension((Vertex)vertex).width;
            int n2 = this.vertexFunctions.getShapeDimension((Vertex)vertex).height;
            if (n > this.columnWidth) {
                this.columnWidth = n;
            }
            if (n2 <= this.rowHeight) continue;
            this.rowHeight = n2;
        }
        this.columnWidth += 20;
    }

    protected void initialize_local_vertex(Vertex vertex) {
        int n = this.rowList.getRow(vertex);
        int n2 = this.rowList.getColumn(vertex);
        int n3 = this.getCurrentSize().width;
        int n4 = this.getCurrentSize().height;
        int n5 = this.rowList.getWidth(n);
        int n6 = this.getColumnWidth();
        int n7 = this.getRowHeight();
        Coordinates coordinates = new Coordinates();
        double d = n2 * n6;
        double d2 = n * (n7 * 3);
        d = d + (double)(n3 / 2) - (double)((n5 - 1) * (n6 / 2));
        d2 = d2 + (double)(n7 / 2) + 3.0;
        coordinates.setX(d);
        coordinates.setY(d2);
        vertex.setUserDatum((Object)COORDS, (Object)coordinates, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
    }

    public double getX(Vertex vertex) {
        return this.getCoordinates((ArchetypeVertex)vertex).getX();
    }

    public double getY(Vertex vertex) {
        return this.getCoordinates((ArchetypeVertex)vertex).getY();
    }

    public Coordinates getCoordinates(ArchetypeVertex archetypeVertex) {
        return (Coordinates)archetypeVertex.getUserDatum((Object)COORDS);
    }

    public void advancePositions() {
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    protected void initialize_local() {
    }
}

