/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantVertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexSizeFunction;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.VertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexSizeFunction;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedInfo;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.CrossoverScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ViewScalingGraphMousePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.drools.RuleBase;
import org.drools.reteoo.ReteooToJungVisitor;
import org.drools.visualize.ReteooJungViewer;
import org.drools.visualize.ReteooLayout;
import org.drools.visualize.ReteooLayoutSolver;
import org.drools.visualize.VertexFunctions;

public class ReteooJungViewerPanel
extends JPanel {
    private static final long serialVersionUID = 73294554831916314L;
    private Graph graph;
    private VisualizationViewer vv;

    public ReteooJungViewerPanel(RuleBase ruleBase) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setDividerLocation(0.75);
        jSplitPane.setResizeWeight(1.0);
        this.add(jSplitPane);
        this.graph = new DirectedSparseGraph();
        ReteooToJungVisitor reteooToJungVisitor = new ReteooToJungVisitor(this.graph);
        reteooToJungVisitor.visit(ruleBase);
        PluggableRenderer pluggableRenderer = new PluggableRenderer();
        pluggableRenderer.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.QuadCurve());
        pluggableRenderer.setVertexPaintFunction(new VertexPaintFunction(){

            public Paint getFillPaint(Vertex vertex) {
                return ((ReteooJungViewer.DroolsVertex)vertex).getFillPaint();
            }

            public Paint getDrawPaint(Vertex vertex) {
                return ((ReteooJungViewer.DroolsVertex)vertex).getDrawPaint();
            }
        });
        pluggableRenderer.setEdgePaintFunction((EdgePaintFunction)new PickableEdgePaintFunction((PickedInfo)pluggableRenderer, (Paint)Color.black, (Paint)Color.cyan));
        pluggableRenderer.setGraphLabelRenderer((GraphLabelRenderer)new DefaultGraphLabelRenderer(Color.cyan, Color.cyan));
        pluggableRenderer.setVertexShapeFunction((VertexShapeFunction)new EllipseVertexShapeFunction((VertexSizeFunction)new ConstantVertexSizeFunction(14), (VertexAspectRatioFunction)new ConstantVertexAspectRatioFunction(1.0f)));
        ReteooLayoutSolver reteooLayoutSolver = new ReteooLayoutSolver(reteooToJungVisitor.getRootVertex());
        ReteooLayout reteooLayout = new ReteooLayout(this.graph, new VertexFunctions(), reteooLayoutSolver.getRowList());
        this.vv = new VisualizationViewer((Layout)reteooLayout, (Renderer)pluggableRenderer);
        this.vv.setBackground(Color.white);
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        this.vv.setToolTipFunction((ToolTipFunction)new DefaultToolTipFunction());
        PluggableGraphMouse pluggableGraphMouse = new PluggableGraphMouse();
        pluggableGraphMouse.add((GraphMousePlugin)new PickingGraphMousePlugin());
        pluggableGraphMouse.add((GraphMousePlugin)new ViewScalingGraphMousePlugin());
        pluggableGraphMouse.add((GraphMousePlugin)new CrossoverScalingGraphMousePlugin());
        pluggableGraphMouse.add((GraphMousePlugin)new RotatingGraphMousePlugin());
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)pluggableGraphMouse);
        CrossoverScalingControl crossoverScalingControl = new CrossoverScalingControl();
        JButton jButton = new JButton("+");
        jButton.addActionListener(new ActionListener((ScalingControl)crossoverScalingControl){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$scaler.scale(ReteooJungViewerPanel.this.vv, 1.1f, ReteooJungViewerPanel.this.vv.getCenter());
            }
        });
        JButton jButton2 = new JButton("-");
        jButton2.addActionListener(new ActionListener((ScalingControl)crossoverScalingControl){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$scaler.scale(ReteooJungViewerPanel.this.vv, 0.9f, ReteooJungViewerPanel.this.vv.getCenter());
            }
        });
        GraphZoomScrollPane graphZoomScrollPane = new GraphZoomScrollPane(this.vv);
        graphZoomScrollPane.scrollRectToVisible(new Rectangle(1, 1, 1, 1));
        jPanel.add((Component)graphZoomScrollPane);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel jPanel4 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel4.add(jPanel3);
        jPanel.add((Component)jPanel4, "South");
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(150, 10));
        jScrollPane.setMinimumSize(new Dimension(150, 10));
        this.vv.addGraphMouseListener(new GraphMouseListener(){

            public void graphClicked(Vertex vertex, MouseEvent mouseEvent) {
                jEditorPane.setText(((ReteooJungViewer.DroolsVertex)vertex).getHtml());
            }

            public void graphPressed(Vertex vertex, MouseEvent mouseEvent) {
            }

            public void graphReleased(Vertex vertex, MouseEvent mouseEvent) {
            }
        });
        jPanel2.add(jScrollPane);
    }
}

