/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.ReturnValueExpression;
import org.drools.spi.Tuple;

public class ReturnValueConstraint
implements FieldConstraint {
    private static final long serialVersionUID = -3888281054472597050L;
    private final FieldExtractor fieldExtractor;
    private ReturnValueExpression expression;
    private final Declaration[] requiredDeclarations;
    private final Evaluator evaluator;
    private static final Declaration[] noRequiredDeclarations = new Declaration[0];

    public ReturnValueConstraint(FieldExtractor fieldExtractor, Declaration[] declarationArray, Evaluator evaluator) {
        this(fieldExtractor, null, declarationArray, evaluator);
    }

    public ReturnValueConstraint(FieldExtractor fieldExtractor, ReturnValueExpression returnValueExpression, Declaration[] declarationArray, Evaluator evaluator) {
        this.fieldExtractor = fieldExtractor;
        this.expression = returnValueExpression;
        this.requiredDeclarations = declarationArray != null ? declarationArray : noRequiredDeclarations;
        this.evaluator = evaluator;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void setReturnValueExpression(ReturnValueExpression returnValueExpression) {
        this.expression = returnValueExpression;
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    public boolean isAllowed(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.evaluator.evaluate(this.fieldExtractor.getValue(internalFactHandle.getObject()), this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory));
        }
        catch (Exception exception) {
            throw new RuntimeDroolsException(exception);
        }
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ReturnValueConstraint.class) {
            return false;
        }
        ReturnValueConstraint returnValueConstraint = (ReturnValueConstraint)object;
        if (this.requiredDeclarations.length != returnValueConstraint.requiredDeclarations.length) {
            return false;
        }
        int n = this.requiredDeclarations.length;
        for (int i = 0; i < n; ++i) {
            if (this.requiredDeclarations[i].getColumn() != returnValueConstraint.requiredDeclarations[i].getColumn()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(returnValueConstraint.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(returnValueConstraint.expression);
    }
}

