/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.common.BetaNodeBinder;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.LeapsRule;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Not;
import org.drools.rule.Rule;
import org.drools.spi.FieldConstraint;

class Builder {
    Builder() {
    }

    protected static final List processRule(Rule rule) throws InvalidPatternException {
        ArrayList arrayList = new ArrayList();
        And[] andArray = rule.getTransformedLhs();
        int n = andArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Builder.processRuleForAnd(andArray[i], rule));
        }
        return arrayList;
    }

    private static final List processRuleForAnd(And and, Rule rule) {
        ArrayList<LeapsRule> arrayList = new ArrayList<LeapsRule>();
        ArrayList<ColumnConstraints> arrayList2 = new ArrayList<ColumnConstraints>();
        ArrayList<ColumnConstraints> arrayList3 = new ArrayList<ColumnConstraints>();
        ArrayList<ColumnConstraints> arrayList4 = new ArrayList<ColumnConstraints>();
        ArrayList<EvalCondition> arrayList5 = new ArrayList<EvalCondition>();
        Iterator iterator = and.getChildren().iterator();
        while (iterator.hasNext()) {
            ColumnConstraints columnConstraints;
            ConditionalElement conditionalElement;
            Object e = iterator.next();
            if (e instanceof EvalCondition) {
                conditionalElement = (EvalCondition)e;
                arrayList5.add((EvalCondition)conditionalElement);
                continue;
            }
            if (e instanceof Column) {
                columnConstraints = Builder.processColumn((Column)e);
            } else {
                conditionalElement = (GroupElement)e;
                while (!(((GroupElement)conditionalElement).getChildren().get(0) instanceof Column)) {
                    conditionalElement = (GroupElement)((GroupElement)conditionalElement).getChildren().get(0);
                }
                columnConstraints = Builder.processColumn((Column)((GroupElement)conditionalElement).getChildren().get(0));
            }
            if (e instanceof Not) {
                arrayList3.add(columnConstraints);
                continue;
            }
            if (e instanceof Exists) {
                arrayList4.add(columnConstraints);
                continue;
            }
            arrayList2.add(columnConstraints);
        }
        Builder.checkEvalUnboundDeclarations(rule, arrayList5);
        arrayList.add(new LeapsRule(rule, arrayList2, arrayList3, arrayList4, arrayList5));
        return arrayList;
    }

    static void checkEvalUnboundDeclarations(Rule rule, ArrayList arrayList) throws InvalidPatternException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            EvalCondition evalCondition = (EvalCondition)object.next();
            Declaration[] declarationArray = evalCondition.getRequiredDeclarations();
            int n = declarationArray.length;
            for (int i = 0; i < n; ++i) {
                if (rule.getDeclaration(declarationArray[i].getIdentifier()) != null) continue;
                arrayList2.add(declarationArray[i].getIdentifier());
            }
        }
        if (arrayList2.size() != 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append(arrayList2.get(0));
            int n = arrayList2.size();
            for (int i = 1; i < n; ++i) {
                ((StringBuffer)object).append(", " + arrayList2.get(i));
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + object);
        }
    }

    private static final ColumnConstraints processColumn(Column column) {
        ArrayList<FieldConstraint> arrayList = new ArrayList<FieldConstraint>();
        ArrayList<FieldConstraint> arrayList2 = new ArrayList<FieldConstraint>();
        Iterator iterator = column.getConstraints().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldConstraint)) continue;
            FieldConstraint fieldConstraint = (FieldConstraint)e;
            if (fieldConstraint.getRequiredDeclarations().length == 0) {
                arrayList.add(fieldConstraint);
                continue;
            }
            arrayList2.add(fieldConstraint);
        }
        BetaNodeBinder betaNodeBinder = !arrayList2.isEmpty() ? new BetaNodeBinder(arrayList2.toArray(new FieldConstraint[arrayList2.size()])) : new BetaNodeBinder();
        return new ColumnConstraints(column, arrayList, betaNodeBinder);
    }
}

