/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.logging;

import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.LogImpl;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.LogNoi18nImpl;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory;
import com.arjuna.common.internal.util.logging.simpleLog.SimpleLogFactory;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import com.arjuna.common.util.logging.LogNoi18n;
import com.arjuna.common.util.logging.Logi18n;

public class LogFactory {
    public static final String LOGGER_PROPERTY = "com.arjuna.common.util.logger";
    public static final String DEBUG_LEVEL = "com.arjuna.common.util.logging.DebugLevel";
    public static final String FACILITY_LEVEL = "com.arjuna.common.util.logging.FacilityLevel";
    public static final String VISIBILITY_LEVEL = "com.arjuna.common.util.logging.VisibilityLevel";
    private static final String JCL_LOG_CONFIGURATION = "org.apache.commons.logging.Log";
    private static final String JAKARTA_LOGGER = "jakarta";
    private static final String DOTNET_LOGGER = "dotnet";
    private static final String LOG4J = "log4j";
    private static final String JDK14 = "jdk14";
    private static final String SIMPLE = "simple";
    private static final String NOOP = "noop";
    private static LogFactoryInterface m_logFactory = null;
    private static boolean m_isInitialized = false;
    private static long m_debugLevel = 0L;
    private static long m_visLevel = -1L;
    private static long m_facLevel = -1L;

    public static LogNoi18n getLogNoi18n(String name) {
        LogNoi18nImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        if (!(logInterface instanceof LogInterface)) {
            throw new RuntimeException("non i18n loggers are not supported for CSF!");
        }
        log = new LogNoi18nImpl((LogInterface)logInterface);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(Class clazz) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
        log = new LogImpl((LogInterface)logInterface);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        log = new LogImpl((LogInterface)logInterface, name);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(Class clazz, String resBundle) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
        log = new LogImpl((LogInterface)logInterface, resBundle);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(Class clazz, String[] resBundles) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
        log = new LogImpl((LogInterface)logInterface, resBundles);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name, String resBundle) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        log = new LogImpl((LogInterface)logInterface, resBundle);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name, String[] resBundles) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        log = new LogImpl((LogInterface)logInterface, resBundles);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    private static synchronized void setupLogSystem() {
        if (m_isInitialized) {
            return;
        }
        String debugLevel = "0xffffffff";
        String facLevel = "0xfffffff";
        String visLevel = "0xfffffff";
        String logSystem = NOOP;
        try {
            try {
                logSystem = commonPropertyManager.propertyManager.getProperty(LOGGER_PROPERTY, null);
                if (logSystem == null) {
                    logSystem = System.getProperty(LOGGER_PROPERTY, NOOP);
                }
                debugLevel = commonPropertyManager.propertyManager.getProperty(DEBUG_LEVEL, "0xffffffff");
                facLevel = commonPropertyManager.propertyManager.getProperty(FACILITY_LEVEL, "0xfffffff");
                visLevel = commonPropertyManager.propertyManager.getProperty(VISIBILITY_LEVEL, "0xfffffff");
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                m_debugLevel = Long.decode(debugLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0L;
            }
            try {
                m_facLevel = Long.decode(facLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            try {
                m_visLevel = Long.decode(visLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            if (logSystem.equals(DOTNET_LOGGER)) {
                logSystem = SIMPLE;
            }
            if (logSystem.equals(LOG4J)) {
                System.setProperty(JCL_LOG_CONFIGURATION, "org.apache.commons.logging.impl.Log4JLogger");
                m_logFactory = new JakartaLogFactory();
            } else if (logSystem.equals(JDK14)) {
                System.setProperty(JCL_LOG_CONFIGURATION, "org.apache.commons.logging.impl.Jdk14Logger");
                m_logFactory = new JakartaLogFactory();
            } else if (logSystem.equals(SIMPLE)) {
                System.setProperty(JCL_LOG_CONFIGURATION, "org.apache.commons.logging.impl.SimpleLog");
                m_logFactory = new JakartaLogFactory();
            } else if (logSystem.equals(NOOP)) {
                System.setProperty(JCL_LOG_CONFIGURATION, "org.apache.commons.logging.impl.NoOpLog");
                m_logFactory = new JakartaLogFactory();
            } else {
                m_logFactory = logSystem.equals(JAKARTA_LOGGER) ? new JakartaLogFactory() : (logSystem.equals(DOTNET_LOGGER) ? new SimpleLogFactory() : new JakartaLogFactory());
            }
        }
        catch (LogConfigurationException e) {
            throw new RuntimeException("An unexpected exception occurred while creating the logger factory: " + e.getMessage());
        }
        m_isInitialized = true;
    }
}

