/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.wsse.EncodingOperation;
import org.jboss.ws.wsse.QNameTarget;
import org.jboss.ws.wsse.SecurityStore;
import org.jboss.ws.wsse.Target;
import org.jboss.ws.wsse.Util;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.WsuIdResolver;
import org.jboss.ws.wsse.WsuIdTarget;
import org.jboss.ws.wsse.element.DirectReference;
import org.jboss.ws.wsse.element.SecurityHeader;
import org.jboss.ws.wsse.element.SecurityTokenReference;
import org.jboss.ws.wsse.element.Signature;
import org.jboss.ws.wsse.element.X509Token;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureOperation
implements EncodingOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public SignatureOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
        this.store = store;
    }

    private void processTarget(XMLSignature sig, Document message, Target target) {
        if (target instanceof QNameTarget) {
            this.processQNameTarget(sig, message, (QNameTarget)target);
        } else if (target instanceof WsuIdTarget) {
            this.processWsuIdTarget(sig, message, (WsuIdTarget)target);
        } else {
            throw new NotImplementedException();
        }
    }

    private void processQNameTarget(XMLSignature sig, Document message, QNameTarget target) {
        QName name = target.getName();
        Transforms transforms = new Transforms(message);
        try {
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (TransformationException e) {
            throw new RuntimeException(e);
        }
        Element element = Util.findElement(message.getDocumentElement(), name);
        if (element == null) {
            throw new RuntimeException("Could not find element");
        }
        String id = Util.assignWsuId(element);
        try {
            sig.addDocument("#" + id, transforms);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private void processWsuIdTarget(XMLSignature sig, Document message, WsuIdTarget target) {
        String id = target.getId();
        Transforms transforms = new Transforms(message);
        try {
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (TransformationException e) {
            throw new RuntimeException(e);
        }
        try {
            sig.addDocument("#" + id, transforms);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(Document message, List<Target> targets, String alias, String credential, String algorithm) throws WSSecurityException {
        XMLSignature sig;
        Element envelope = message.getDocumentElement();
        try {
            sig = new XMLSignature(message, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Error building signature", e);
        }
        sig.addResourceResolver((ResourceResolverSpi)new WsuIdResolver(message, this.header.getElement()));
        PrivateKey key = this.store.getPrivateKey(alias);
        if (targets == null || targets.size() == 0) {
            String namespace = envelope.getNamespaceURI();
            this.processTarget(sig, message, new QNameTarget(new QName(namespace, "Body")));
            if (this.header.getTimestamp() != null) {
                this.processTarget(sig, message, new WsuIdTarget("timestamp"));
            }
        } else {
            for (Target target : targets) {
                this.processTarget(sig, message, target);
            }
        }
        try {
            sig.sign((Key)key);
        }
        catch (XMLSignatureException e) {
            throw new WSSecurityException("Error signing message: " + e.getMessage(), e);
        }
        X509Certificate cert = this.store.getCertificate(alias);
        X509Token token = (X509Token)this.header.getSharedToken(cert);
        if (token == null) {
            token = new X509Token(cert, message);
            this.header.addToken(token);
        }
        SecurityTokenReference reference = new SecurityTokenReference(new DirectReference(message, token));
        sig.getKeyInfo().addUnknownElement(reference.getElement());
        this.header.addSecurityProcess(new Signature(sig));
    }
}

