/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jboss.logging.Logger;
import org.jboss.ws.utils.UUIDGenerator;

public class CIDGenerator {
    private static Logger log = Logger.getLogger(CIDGenerator.class);
    private int count = 0;

    public String generateFromCount() {
        StringBuilder cid = new StringBuilder();
        long time = System.currentTimeMillis();
        cid.append("cid:").append(this.count++).append("-").append(time).append("-").append(cid.hashCode()).append("@").append("ws.jboss.org");
        log.debug((Object)("generateFromCount: " + cid));
        return cid.toString();
    }

    public String generateFromName(String name) {
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)("Cannot encode name for cid: " + ex));
        }
        String cid = "cid:" + name + "-" + UUIDGenerator.generateRandomUUIDString() + "@" + "ws.jboss.org";
        log.debug((Object)("generateFromName: " + cid));
        return cid;
    }
}

