/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPPart;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.Constants;
import org.jboss.ws.handler.HandlerWrapper;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerChainBaseImpl
implements HandlerChain {
    private static Logger log = Logger.getLogger(HandlerChainBaseImpl.class);
    public static final int STATE_DOES_NOT_EXIST = 0;
    public static final int STATE_CREATED = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROYED = 3;
    protected List<HandlerEntry> handlers = new ArrayList<HandlerEntry>();
    protected Set<String> roles = new HashSet<String>();
    protected int falseIndex = -1;
    protected int state;

    public HandlerChainBaseImpl(List infos, Set roles) {
        log.debug((Object)("Create a handler chain for roles: " + roles));
        this.addHandlersToChain(infos, roles);
    }

    public List<HandlerInfo> getHandlerInfos() {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            list.add(entry.info);
        }
        return list;
    }

    private void addHandlersToChain(List infos, Set roleSet) {
        try {
            if (infos != null) {
                for (int i = 0; i < infos.size(); ++i) {
                    HandlerInfo info = (HandlerInfo)infos.get(i);
                    HandlerWrapper handler = new HandlerWrapper((Handler)info.getHandlerClass().newInstance());
                    this.handlers.add(new HandlerEntry(handler, info));
                }
            }
            if (roleSet != null) {
                this.roles.addAll(roleSet);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("Cannot initialize handler chain", (Throwable)e);
        }
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public void init(Map config) {
        log.debug((Object)("init: [config=" + config + "]"));
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.init(entry.info);
        }
        this.state = 2;
    }

    public void destroy() {
        log.debug((Object)"destroy");
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.destroy();
        }
        this.handlers.clear();
        this.state = 3;
    }

    public String[] getRoles() {
        String[] arr = new String[this.roles.size()];
        this.roles.toArray(arr);
        return arr;
    }

    public void setRoles(String[] soapActorNames) {
        List<String> newRoles = Arrays.asList(soapActorNames);
        log.debug((Object)("setRoles: " + newRoles));
        this.roles.clear();
        this.roles.addAll(newRoles);
    }

    public boolean handleRequest(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            int handlerIndex;
            log.debug((Object)"Enter: handleRequest");
            this.replaceDirtyHandlers();
            Handler currHandler = null;
            try {
                for (handlerIndex = 0; doNext && handlerIndex < this.handlers.size(); ++handlerIndex) {
                    SOAPPart soapPart;
                    SOAPMessageContextImpl msgCtx;
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)("Handle request: " + currHandler));
                    doNext = currHandler.handleRequest(msgContext);
                    if (!log.isTraceEnabled()) continue;
                    msgCtx = (SOAPMessageContextImpl)msgContext;
                    soapPart = msgCtx.getMessage().getSOAPPart();
                    lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"RuntimeException in request handler", (Throwable)e);
                doNext = false;
                throw e;
            }
            finally {
                if (!doNext) {
                    this.falseIndex = handlerIndex - 1;
                }
                log.debug((Object)("Exit: handleRequest with status: " + doNext));
            }
        }
        return doNext;
    }

    public boolean handleResponse(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            log.debug((Object)"Enter: handleResponse");
            int handlerIndex = this.handlers.size() - 1;
            if (this.falseIndex != -1) {
                handlerIndex = this.falseIndex;
            }
            Handler currHandler = null;
            try {
                while (doNext && handlerIndex >= 0) {
                    SOAPPart soapPart;
                    SOAPMessageContextImpl msgCtx;
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)("Handle response: " + currHandler));
                    doNext = currHandler.handleResponse(msgContext);
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    --handlerIndex;
                }
            }
            catch (RuntimeException rte) {
                log.error((Object)"RuntimeException in response handler", (Throwable)rte);
                doNext = false;
                throw rte;
            }
            finally {
                if (!doNext) {
                    this.falseIndex = handlerIndex - 1;
                }
                log.debug((Object)("Exit: handleResponse with status: " + doNext));
            }
        }
        return doNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            log.debug((Object)"Enter: handleFault");
            try {
                int handlerIndex = this.handlers.size() - 1;
                if (this.falseIndex != -1) {
                    handlerIndex = this.falseIndex;
                }
                Handler currHandler = null;
                while (doNext && handlerIndex >= 0) {
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)("Handle fault: " + currHandler));
                    doNext = currHandler.handleFault(msgContext);
                    --handlerIndex;
                }
            }
            finally {
                log.debug((Object)("Exit: handleFault with status: " + doNext));
            }
        }
        return doNext;
    }

    protected String traceSOAPPart(SOAPPart soapPart, String lastMessageTrace) {
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
            String envString = DOMWriter.printNode((Node)((Object)soapEnv), (boolean)true);
            if (!envString.equals(lastMessageTrace)) {
                log.debug((Object)envString);
                lastMessageTrace = envString;
            }
            return lastMessageTrace;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot get SOAPEnvelope", (Throwable)e);
            return null;
        }
    }

    protected void replaceDirtyHandlers() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            HandlerEntry entry = this.handlers.get(i);
            if (entry.handler.getState() != 0) continue;
            log.debug((Object)("Replacing dirty handler: " + entry.handler));
            try {
                HandlerWrapper handler = new HandlerWrapper((Handler)entry.info.getHandlerClass().newInstance());
                entry.handler = handler;
                handler.init(entry.info);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Cannot create handler instance for: " + entry.info));
            }
        }
    }

    protected Handler getHandlerAt(int pos) {
        if (pos < 0 || this.handlers.size() <= pos) {
            throw new IllegalArgumentException("No handler at position: " + pos);
        }
        HandlerEntry entry = this.handlers.get(pos);
        return entry.handler;
    }

    public static void checkMustUnderstand(SOAPMessageContextImpl msgContext, String[] roles) {
        SOAPHeaderElement mustUnderstandHeaderElement = null;
        ArrayList roleList = roles != null ? Arrays.asList(roles) : new ArrayList();
        try {
            SOAPEnvelope soapEnvelope;
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getMessage();
            OperationMetaData opMetaData = msgContext.getOperationMetaData();
            if (opMetaData == null) {
                EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
                opMetaData = soapMessage.getOperationMetaData(epMetaData);
            }
            if ((soapEnvelope = soapMessage.getSOAPPart().getEnvelope()) != null && soapEnvelope.getHeader() != null) {
                Iterator it = soapEnvelope.getHeader().examineAllHeaderElements();
                while (it.hasNext() && mustUnderstandHeaderElement == null) {
                    boolean isBoundHeader;
                    SOAPHeaderElement soapHeaderElement = (SOAPHeaderElement)it.next();
                    Name name = soapHeaderElement.getElementName();
                    QName xmlName = new QName(name.getURI(), name.getLocalName());
                    ParameterMetaData paramMetaData = opMetaData != null ? opMetaData.getParameter(xmlName) : null;
                    boolean bl = isBoundHeader = paramMetaData != null && paramMetaData.isInHeader();
                    if (!soapHeaderElement.getMustUnderstand() || isBoundHeader) continue;
                    String actor = soapHeaderElement.getActor();
                    boolean noActor = actor == null || actor.length() == 0;
                    boolean nextActor = "http://schemas.xmlsoap.org/soap/actor/next".equals(actor);
                    if (!noActor && !nextActor && !roleList.contains(actor)) continue;
                    mustUnderstandHeaderElement = soapHeaderElement;
                }
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot check mustUnderstand for headers", (Throwable)ex);
        }
        if (mustUnderstandHeaderElement != null) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
            String faultString = "Unprocessed 'mustUnderstand' header element: " + mustUnderstandHeaderElement.getElementName();
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
    }

    public boolean remove(Object o) {
        return this.handlers.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.handlers.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.handlers.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.handlers.retainAll(c);
    }

    public int hashCode() {
        return ((Object)this.handlers).hashCode();
    }

    public boolean equals(Object o) {
        return ((Object)this.handlers).equals(o);
    }

    public Iterator iterator() {
        return this.handlers.iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.handlers.subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.handlers.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.handlers.listIterator(index);
    }

    public int size() {
        return this.handlers.size();
    }

    public void clear() {
        this.handlers.clear();
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public Object[] toArray() {
        return this.handlers.toArray();
    }

    public Object get(int index) {
        return this.handlers.get(index);
    }

    public Object remove(int index) {
        return this.handlers.remove(index);
    }

    public void add(int index, Object element) {
        this.handlers.add(index, (HandlerEntry)element);
    }

    public int indexOf(Object elem) {
        return this.handlers.indexOf(elem);
    }

    public int lastIndexOf(Object elem) {
        return this.handlers.lastIndexOf(elem);
    }

    public boolean add(Object o) {
        return this.handlers.add((HandlerEntry)o);
    }

    public boolean contains(Object elem) {
        return this.handlers.contains(elem);
    }

    public boolean addAll(int index, Collection c) {
        return this.handlers.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.handlers.addAll(c);
    }

    public Object set(int index, Object element) {
        return this.handlers.set(index, (HandlerEntry)element);
    }

    public Object[] toArray(Object[] a) {
        return this.handlers.toArray(a);
    }

    private class HandlerEntry {
        private HandlerWrapper handler;
        private HandlerInfo info;

        public HandlerEntry(HandlerWrapper handler, HandlerInfo info) {
            this.handler = handler;
            this.info = info;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public HandlerInfo getInfo() {
            return this.info;
        }
    }
}

