/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.ConsumerEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class ConsumerChangeRateRequest
extends RequestSupport {
    private float newRate;

    public ConsumerChangeRateRequest() {
    }

    public ConsumerChangeRateRequest(String objectId, byte version, float newRate) {
        super(objectId, 401, version);
        this.newRate = newRate;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.newRate = is.readFloat();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConsumerEndpoint endpoint = (ConsumerEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.changeRate(this.newRate);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeFloat(this.newRate);
        os.flush();
    }
}

